/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.eventspy_30;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.project.MavenProject;
import org.hudsonci.maven.eventspy_30.ProfileCollector;
import org.hudsonci.maven.eventspy_30.ResolvedProfile;
import org.hudsonci.maven.model.MavenCoordinatesDTO;
import org.hudsonci.maven.model.ThrowableDTOHelper;
import org.hudsonci.maven.model.state.BuildResultDTO;
import org.hudsonci.maven.model.state.BuildSummaryDTO;
import org.hudsonci.maven.model.state.MavenProjectDTO;
import org.hudsonci.maven.model.state.ProfileDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProjectConverter {
    private MavenProjectConverter() {
    }

    public static ArrayList<MavenProjectDTO> extractFrom(MavenExecutionResult event) {
        ArrayList<MavenProjectDTO> participatingProjects = new ArrayList<MavenProjectDTO>();
        List projects = event.getTopologicallySortedProjects();
        for (MavenProject mavenProject : projects) {
            MavenProjectDTO projectDTO = MavenProjectConverter.convertMavenProject(mavenProject);
            MavenProjectConverter.updateWithBuildSummary(projectDTO, event.getBuildSummary(mavenProject));
            participatingProjects.add(projectDTO);
        }
        return participatingProjects;
    }

    public static MavenProjectDTO convertMavenProject(MavenProject mavenProject) {
        Preconditions.checkNotNull((Object)mavenProject);
        MavenProjectDTO projectDTO = new MavenProjectDTO().withName(mavenProject.getName()).withCoordinates(MavenProjectConverter.asCoordinates(mavenProject)).withProfiles(MavenProjectConverter.convertProfiles(ProfileCollector.collect(mavenProject)));
        return projectDTO;
    }

    public static MavenCoordinatesDTO asCoordinates(MavenProject mavenProject) {
        Preconditions.checkNotNull((Object)mavenProject);
        return new MavenCoordinatesDTO().withGroupId(mavenProject.getGroupId()).withArtifactId(mavenProject.getArtifactId()).withType(MavenProjectConverter.nullSafeString(mavenProject.getPackaging())).withVersion(mavenProject.getVersion()).normalize();
    }

    private static String nullSafeString(String original) {
        return original == null || original.length() == 0 ? "" : original;
    }

    public static void updateWithBuildSummary(MavenProjectDTO projectDTO, BuildSummary buildSummary) {
        Preconditions.checkNotNull((Object)projectDTO);
        projectDTO.setBuildSummary(MavenProjectConverter.convertBuildSummary(buildSummary));
    }

    public static void updateWithBuildResult(MavenProjectDTO projectDTO, BuildResultDTO resultDTO) {
        Preconditions.checkNotNull((Object)projectDTO);
        Preconditions.checkNotNull((Object)resultDTO);
        projectDTO.setBuildSummary(new BuildSummaryDTO().withResult(resultDTO));
    }

    public static BuildSummaryDTO convertBuildSummary(BuildSummary buildSummary) {
        BuildSummaryDTO buildSummaryDTO = new BuildSummaryDTO().withResult(MavenProjectConverter.convertToBuildResult(buildSummary));
        if (buildSummary != null) {
            Throwable cause;
            buildSummaryDTO.setDuration(Long.valueOf(buildSummary.getTime()));
            if (buildSummary instanceof BuildFailure && (cause = ((BuildFailure)buildSummary).getCause()) != null) {
                buildSummaryDTO.setFailureCause(ThrowableDTOHelper.convert((Throwable)cause));
            }
        }
        return buildSummaryDTO;
    }

    public static BuildResultDTO convertToBuildResult(BuildSummary buildSummary) {
        BuildResultDTO result = buildSummary == null ? BuildResultDTO.SKIPPED : (buildSummary instanceof BuildSuccess ? BuildResultDTO.SUCCESS : (buildSummary instanceof BuildFailure ? BuildResultDTO.FAILURE : BuildResultDTO.UNKNOWN));
        return result;
    }

    public static Collection<ProfileDTO> convertProfiles(Collection<ResolvedProfile> profiles) {
        Preconditions.checkNotNull(profiles);
        ArrayList<ProfileDTO> profilesDTO = new ArrayList<ProfileDTO>();
        for (ResolvedProfile resolvedProfile : profiles) {
            profilesDTO.add(new ProfileDTO().withId(resolvedProfile.getId()).withSource(resolvedProfile.getSource()).withActive(resolvedProfile.isActive()));
        }
        return profilesDTO;
    }
}

