/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.eventspy_30.handler;

import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.PluginArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLogger {
    private static final Logger log = LoggerFactory.getLogger(ProjectLogger.class);
    private static final boolean disabled = Boolean.valueOf(System.getProperty("hudson.eventspy.logging.project")) == false;

    public static void log(MavenProject project, String where) {
        if (disabled) {
            return;
        }
        log.debug("MavenProject ({}) artifacts @ {}:", (Object)project.getId(), (Object)where);
        ProjectLogger.logArtifactContents("artifacts", project.getArtifacts());
        ProjectLogger.logArtifactContents("attachedArtifacts", project.getAttachedArtifacts());
        ProjectLogger.logArtifactContents("dependencyArtifacts", project.getDependencyArtifacts());
        ProjectLogger.logArtifactContents("extensionArtifacts", project.getExtensionArtifacts());
        ProjectLogger.logArtifactContents("pluginArtifacts", project.getPluginArtifacts());
        for (Artifact artifact : project.getPluginArtifacts()) {
            if (!(artifact instanceof PluginArtifact)) continue;
            List dependencies = ((PluginArtifact)artifact).getDependencies();
            Integer maybeSize = dependencies == null ? null : Integer.valueOf(dependencies.size());
            log.debug("  {} pluginDependencies: {}", (Object)maybeSize, (Object)dependencies);
        }
    }

    private static void logArtifactContents(String method, Collection<? extends Artifact> artifacts) {
        Integer maybeSize = artifacts == null ? null : Integer.valueOf(artifacts.size());
        log.debug("  {} " + method + ": {}", (Object)maybeSize, artifacts);
    }
}

