/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.eventspy_30.recorder;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.project.MavenProject;
import org.hudsonci.maven.eventspy.common.Callback;
import org.hudsonci.maven.eventspy_30.MavenArtifactConverter;
import org.hudsonci.maven.eventspy_30.MavenProjectConverter;
import org.hudsonci.maven.model.MavenCoordinatesDTO;
import org.hudsonci.maven.model.state.ArtifactActionDTO;
import org.hudsonci.maven.model.state.ArtifactDTO;
import org.hudsonci.maven.model.state.ArtifactOperationDTO;
import org.hudsonci.maven.model.state.BuildResultDTO;
import org.hudsonci.maven.model.state.MavenProjectDTO;
import org.hudsonci.maven.model.state.MavenProjectDTOHelper;
import org.hudsonci.utils.common.TestAccessible;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.graph.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildRecorder {
    private static final Logger log = LoggerFactory.getLogger(BuildRecorder.class);
    private MavenCoordinatesDTO resolvingProjectCoordinates;
    private final Callback callback;
    private String executingProjectId;
    private int dependencyArtifactCount = 0;
    private int recordedArtifactCount = 0;
    private long commitDurationToDate = 0L;
    private ArrayList<ArtifactDTO> recordedArtifacts = new ArrayList(350);

    public BuildRecorder(Callback callback) {
        this.callback = callback;
    }

    public void recordArtifactAction(ArtifactDTO artifact, ArtifactOperationDTO operation, File file) {
        Preconditions.checkNotNull((Object)artifact);
        Preconditions.checkNotNull((Object)operation);
        artifact.withRepositoryFile(this.resolveFile(file)).withActions(new ArtifactActionDTO[]{new ArtifactActionDTO().withProjectId(this.executingProjectId).withOperation(operation)});
        if (ArtifactOperationDTO.INSTALLED.equals((Object)operation)) {
            artifact.withCreatedProject(this.executingProjectId);
        } else {
            artifact.withConsumingProjects(new String[]{this.executingProjectId});
        }
        this.recordArtifact(artifact);
    }

    @Deprecated
    public void recordArtifactAction(MavenCoordinatesDTO coordinates, ArtifactOperationDTO operation, File file, String artifactType) {
        Preconditions.checkNotNull((Object)coordinates);
        Preconditions.checkNotNull((Object)operation);
        ArtifactDTO artifact = new ArtifactDTO().withCoordinates(coordinates).withType(artifactType).withRepositoryFile(this.resolveFile(file)).withActions(new ArtifactActionDTO[]{new ArtifactActionDTO().withProjectId(this.executingProjectId).withOperation(operation)});
        if (ArtifactOperationDTO.INSTALLED.equals((Object)operation)) {
            artifact.withCreatedProject(this.executingProjectId);
        } else {
            artifact.withConsumingProjects(new String[]{this.executingProjectId});
        }
        this.recordArtifact(artifact);
    }

    private String resolveFile(File file) {
        String path = null;
        if (file != null) {
            try {
                path = file.getCanonicalPath();
                log.debug("Computed artifact path for {} as canonicalPath {}", (Object)file.getName(), (Object)path);
            }
            catch (IOException e) {
                log.error("File could not be resolved", (Throwable)e);
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordArtifact(ArtifactDTO artifact) {
        ArrayList<ArtifactDTO> arrayList = this.recordedArtifacts;
        synchronized (arrayList) {
            this.recordedArtifacts.add((ArtifactDTO)Preconditions.checkNotNull((Object)artifact));
            ++this.recordedArtifactCount;
        }
    }

    public void recordDependencyResolutionStarted(MavenProject mavenProject) {
        if (mavenProject != null) {
            log.debug("Requested dependencies for {}", (Object)mavenProject);
            this.setResolvingProject(mavenProject);
        } else {
            log.debug("Requested dependencies for {}", (Object)"a non-project");
            this.resetResolvingProject();
        }
    }

    public void recordDependencyResolutionFinished(List<Dependency> resolvedDependencies) {
        Preconditions.checkNotNull(resolvedDependencies);
        log.debug("Recording dependencies for {}:", (Object)this.resolvingProjectCoordinates);
        for (Dependency dependency : resolvedDependencies) {
            log.debug("    {}", (Object)dependency.toString());
            if (!this.isResolvingProjectRequests()) continue;
            ArtifactDTO artifactDto = MavenArtifactConverter.convertAetherArtifact(dependency.getArtifact());
            artifactDto.withDependentProjects(new String[]{MavenProjectDTOHelper.asId((MavenCoordinatesDTO)this.resolvingProjectCoordinates)});
            this.recordArtifact(artifactDto);
            ++this.dependencyArtifactCount;
        }
    }

    public void recordSessionFinished(List<MavenProjectDTO> participatingProjects) {
        this.callback.setParticipatingProjects(participatingProjects);
        this.commitArtifacts();
    }

    private boolean isResolvingProjectRequests() {
        return this.resolvingProjectCoordinates != null;
    }

    private void setResolvingProject(MavenProject mavenProject) {
        this.resolvingProjectCoordinates = MavenProjectConverter.asCoordinates(mavenProject);
    }

    private void resetResolvingProject() {
        this.resolvingProjectCoordinates = null;
    }

    public void recordSessionStarted(List<MavenProject> projects) {
        ArrayList<MavenProjectDTO> participatingProjects = new ArrayList<MavenProjectDTO>();
        for (MavenProject project : projects) {
            MavenProjectDTO projectDTO = MavenProjectConverter.convertMavenProject(project);
            MavenProjectConverter.updateWithBuildResult(projectDTO, BuildResultDTO.SCHEDULED);
            participatingProjects.add(projectDTO);
        }
        this.callback.setParticipatingProjects(participatingProjects);
    }

    public void recordProjectStarted(MavenProject project) {
        MavenProjectDTO projectDTO = MavenProjectConverter.convertMavenProject(project);
        MavenProjectConverter.updateWithBuildResult(projectDTO, BuildResultDTO.BUILDING);
        this.updateProject(projectDTO);
    }

    public void recordProjectFinished(MavenProject project, BuildSummary buildSummary) {
        MavenProjectDTO projectDTO = MavenProjectConverter.convertMavenProject(project);
        MavenProjectConverter.updateWithBuildSummary(projectDTO, buildSummary);
        this.updateProject(projectDTO);
    }

    private void updateProject(MavenProjectDTO project) {
        this.callback.updateParticipatingProject(project);
        if (project.getBuildSummary() != null && BuildResultDTO.BUILDING.equals((Object)project.getBuildSummary().getResult())) {
            this.executingProjectId = project.getId();
            log.debug("Current executing project: {}.", (Object)this.executingProjectId);
        } else {
            this.commitArtifacts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestAccessible
    List<ArtifactDTO> getRecordedArtifacts() {
        ArrayList<ArtifactDTO> arrayList = this.recordedArtifacts;
        synchronized (arrayList) {
            return this.recordedArtifacts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitArtifacts() {
        ArrayList<ArtifactDTO> arrayList = this.recordedArtifacts;
        synchronized (arrayList) {
            long start = System.currentTimeMillis();
            this.callback.addArtifacts(this.recordedArtifacts);
            long duration = System.currentTimeMillis() - start;
            this.commitDurationToDate += duration;
            log.debug("Committed {} artifacts in {}ms of cumulative {}ms: {} dependencies of {} recorded", new Object[]{this.recordedArtifacts.size(), duration, this.commitDurationToDate, this.dependencyArtifactCount, this.recordedArtifactCount});
            this.recordedArtifacts.clear();
        }
    }
}

