/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.eventspy.common;

import com.google.common.base.Preconditions;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hudsonci.maven.eventspy.common.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackManager {
    private static final Logger log = LoggerFactory.getLogger(CallbackManager.class);
    private static final CountDownLatch gate = new CountDownLatch(1);
    private static Callback instance;

    public static Callback get(long timeout, TimeUnit unit) {
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((Object)unit));
        try {
            if (gate.await(timeout, unit)) {
                Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"Callback missing after installation");
                return instance;
            }
            throw new RuntimeException(String.format("Callback not installed in expected time-window: %d %s", new Object[]{timeout, unit}));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for callback", e);
        }
    }

    public static void set(Callback target) {
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Duplicate installation of callback instance is forbidden");
        instance = target;
        log.debug("Callback installed: {}", (Object)instance);
        gate.countDown();
    }
}

