/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.model;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hudsonci.maven.model.MavenCoordinatesDTO;
import org.junit.Assert;
import org.junit.Test;

public class MavenCoordinatesDTOTest {
    @Test
    public void testToString() {
        MavenCoordinatesDTO ga = new MavenCoordinatesDTO().withGroupId("gid").withArtifactId("aid");
        MatcherAssert.assertThat((Object)"{g=gid,a=aid}", (Matcher)Matchers.equalTo((Object)ga.toString()));
        MavenCoordinatesDTO gav = new MavenCoordinatesDTO().withGroupId("gid").withArtifactId("aid").withVersion("version");
        MatcherAssert.assertThat((Object)"{g=gid,a=aid,v=version}", (Matcher)Matchers.equalTo((Object)gav.toString()));
        MavenCoordinatesDTO gatc = new MavenCoordinatesDTO().withGroupId("gid").withArtifactId("aid").withType("type").withClassifier("classifier");
        MatcherAssert.assertThat((Object)"{g=gid,a=aid,t=type,c=classifier}", (Matcher)Matchers.equalTo((Object)gatc.toString()));
    }

    @Test
    public void isIdenticalBasedOnAllAttributes() {
        MavenCoordinatesDTO original = new MavenCoordinatesDTO().withGroupId("gid").withArtifactId("aid").withType("type").withClassifier("classifier");
        MavenCoordinatesDTO duplicate = new MavenCoordinatesDTO().withGroupId("gid").withArtifactId("aid").withType("type").withClassifier("classifier");
        this.verifyIdentity(original, duplicate);
    }

    @Test
    public void isIdenticalWithMissingClassifier() {
        MavenCoordinatesDTO original = new MavenCoordinatesDTO().withGroupId("gid").withArtifactId("aid").withType("type");
        MavenCoordinatesDTO duplicate = new MavenCoordinatesDTO().withGroupId("gid").withArtifactId("aid").withType("type");
        this.verifyIdentity(original, duplicate);
    }

    @Test
    public void normalizationOptionalAttributes() {
        MavenCoordinatesDTO coords = new MavenCoordinatesDTO().withGroupId("").withArtifactId("").withClassifier("").withType("").withVersion("").normalize();
        Assert.assertEquals((Object)"", (Object)coords.getGroupId());
        Assert.assertEquals((Object)"", (Object)coords.getArtifactId());
        Assert.assertNull((Object)coords.getClassifier());
        Assert.assertNull((Object)coords.getType());
        Assert.assertNull((Object)coords.getVersion());
    }

    private void verifyIdentity(MavenCoordinatesDTO original, MavenCoordinatesDTO duplicate) {
        MatcherAssert.assertThat((Object)original, (Matcher)Matchers.equalTo((Object)duplicate));
        MatcherAssert.assertThat((Object)original.hashCode(), (Matcher)Matchers.equalTo((Object)duplicate.hashCode()));
        duplicate.withArtifactId("not-the-same");
        MatcherAssert.assertThat((Object)original, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)duplicate)));
        MatcherAssert.assertThat((Object)original.hashCode(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)duplicate.hashCode())));
    }

    @Test
    public void testIsSnapshot() {
        MavenCoordinatesDTO c1 = new MavenCoordinatesDTO().withVersion("1-SNAPSHOT");
        Assert.assertTrue((boolean)c1.isSnapshot());
        MavenCoordinatesDTO c2 = new MavenCoordinatesDTO().withVersion("1");
        Assert.assertFalse((boolean)c2.isSnapshot());
        MavenCoordinatesDTO c3 = new MavenCoordinatesDTO().withVersion("1-SNAPSHOT-1");
        Assert.assertFalse((boolean)c3.isSnapshot());
    }
}

