/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.model;

import com.thoughtworks.xstream.XStream;
import org.hudsonci.maven.model.MavenCoordinatesDTO;
import org.hudsonci.maven.model.UniqueList;
import org.hudsonci.maven.model.state.ArtifactDTO;
import org.junit.Assert;
import org.junit.Test;

public class UniqueListTest {
    @Test
    public void testAddDuplicates() {
        UniqueList list = new UniqueList();
        list.add((Object)"foo");
        list.add((Object)"bar");
        Assert.assertEquals((long)2L, (long)list.size());
        list.add((Object)"bar");
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testRemove() {
        UniqueList list = new UniqueList();
        list.add((Object)"foo");
        list.add((Object)"bar");
        Assert.assertEquals((long)2L, (long)list.size());
        list.remove((Object)"bar");
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testSerializationViaXStream() throws Exception {
        XStream xs = new XStream();
        xs.processAnnotations(UniqueList.class);
        UniqueList list1 = new UniqueList();
        list1.add((Object)"foo");
        list1.add((Object)"bar");
        String xml = xs.toXML((Object)list1);
        UniqueList list2 = (UniqueList)xs.fromXML(xml);
        Assert.assertEquals((Object)list1, (Object)list2);
    }

    @Test
    public void testSerializationViaXStreamWithManualDuplicates() throws Exception {
        XStream xs = new XStream();
        xs.processAnnotations(UniqueList.class);
        String xml = "<unique-list>\n  <string>foo</string>\n  <string>foo</string>\n  <string>foo</string>\n  <string>bar</string>\n  <string>bar</string>\n</unique-list>";
        UniqueList list = (UniqueList)xs.fromXML(xml);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"foo", (Object)list.get(0));
        Assert.assertEquals((Object)"bar", (Object)list.get(1));
    }

    @Test
    public void testArtifactListSerialization() throws Exception {
        XStream xs = new XStream();
        xs.processAnnotations(new Class[]{UniqueList.class, ArtifactDTO.class});
        UniqueList list1 = new UniqueList();
        list1.add((Object)new ArtifactDTO().withCoordinates(new MavenCoordinatesDTO().withGroupId("gid").withArtifactId("aid")));
        String xml = xs.toXML((Object)list1);
        UniqueList list2 = (UniqueList)xs.fromXML(xml);
        Assert.assertEquals((Object)list1, (Object)list2);
    }
}

