/**
 * The MIT License
 *
 * Copyright (c) 2010-2011 Sonatype, Inc. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package org.hudsonci.maven.plugin.dependencymonitor;

import org.hudsonci.maven.plugin.dependencymonitor.internal.DependencyMonitorImpl;

import com.google.inject.ImplementedBy;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.DependencyGraph;
import hudson.model.TaskListener;

/**
 * Provides access to project dependency monitoring.
 *
 * @author <a href="mailto:jason@planet57.com">Jason Dillon</a>
 * @since 2.1.0
 */
@ImplementedBy(DependencyMonitorImpl.class)
public interface DependencyMonitor
{
    // TODO: allow external repo/URL monitoring to be hooked up (so we can merge in the snapshot monitor plugin features)

    /**
     * Subscribe a project to receive notifications when one of its dependencies has changed.
     */
    void subscribe(AbstractProject project);

    /**
     * Unsubscribe a project from receiving notifications about dependency changes.
     */
    void unsubscribe(AbstractProject project);

    /**
     * Purge subscription details as well as any cached artifact details for the given project.
     */
    void purge(AbstractProject project);

    /**
     * Update the artifact details for the given builds project.
     */
    void update(AbstractBuild build, TaskListener listener);

    /**
     * Build the dependency graph for projects that <em>depend</em> on the given project.
     */
    void buildGraph(AbstractProject project, DependencyGraph graph);
}
