/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.XmlFile;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.json.JSONObject;
import org.hudsonci.maven.model.ModelUtil;
import org.hudsonci.maven.model.PropertiesDTO;
import org.hudsonci.maven.model.config.BuildConfigurationDTO;
import org.hudsonci.maven.model.config.ChecksumModeDTO;
import org.hudsonci.maven.model.config.DocumentDTO;
import org.hudsonci.maven.model.config.DocumentTypeDTO;
import org.hudsonci.maven.model.config.FailModeDTO;
import org.hudsonci.maven.model.config.MakeModeDTO;
import org.hudsonci.maven.model.config.SnapshotUpdateModeDTO;
import org.hudsonci.maven.model.config.VerbosityDTO;
import org.hudsonci.maven.plugin.builder.MavenBuilder;
import org.hudsonci.maven.plugin.builder.internal.BuildConfigurationExtractor;
import org.hudsonci.maven.plugin.documents.DocumentManager;
import org.hudsonci.maven.plugin.install.MavenInstallation;
import org.hudsonci.service.SecurityService;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.hudsonci.utils.plugin.ui.RenderableEnum;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
@Typed(value={Descriptor.class})
@XStreamAlias(value="maven-builder-descriptor")
public class MavenBuilderDescriptor
extends BuildStepDescriptor<Builder> {
    public static final BuildConfigurationDTO DEFAULTS = new BuildConfigurationDTO().withGoals("clean install").withPomFile("pom.xml").withPrivateRepository(Boolean.valueOf(true)).withPrivateTmpdir(Boolean.valueOf(false)).withOffline(Boolean.valueOf(false)).withRecursive(Boolean.valueOf(true)).withErrors(Boolean.valueOf(false)).withVerbosity(VerbosityDTO.NORMAL).withChecksumMode(ChecksumModeDTO.NORMAL).withFailMode(FailModeDTO.NORMAL).withMakeMode(MakeModeDTO.NONE).withSnapshotUpdateMode(SnapshotUpdateModeDTO.NORMAL);
    public static final String DESCRIPTOR_FILE_NAME = "maven-builder-descriptor.xml";
    @XStreamOmitField
    private final SecurityService security;
    @XStreamOmitField
    private final DocumentManager documents;
    @XStreamOmitField
    private final MavenInstallation.DescriptorImpl installationDescriptor;
    private BuildConfigurationDTO defaults = DEFAULTS;

    @Inject
    public MavenBuilderDescriptor(SecurityService security, DocumentManager documents, MavenInstallation.DescriptorImpl installationDescriptor) {
        super(MavenBuilder.class);
        this.security = (SecurityService)Preconditions.checkNotNull((Object)security);
        this.documents = (DocumentManager)Preconditions.checkNotNull((Object)documents);
        this.installationDescriptor = (MavenInstallation.DescriptorImpl)Preconditions.checkNotNull((Object)installationDescriptor);
        this.load();
    }

    public String getDisplayName() {
        return "Invoke Maven 3";
    }

    public boolean isApplicable(Class<? extends AbstractProject> type) {
        return true;
    }

    public XmlFile getConfigFile() {
        return new XmlFile(new File(Hudson.getInstance().getRootDir(), DESCRIPTOR_FILE_NAME));
    }

    @JellyAccessible
    public BuildConfigurationDTO getDefaults() {
        return this.defaults;
    }

    public DocumentManager getDocuments() {
        return this.documents;
    }

    public void setDefaults(BuildConfigurationDTO defaults) {
        this.defaults = (BuildConfigurationDTO)Preconditions.checkNotNull((Object)defaults);
        this.save();
    }

    @JellyAccessible
    public RenderableEnum[] getVerbosityValues() {
        return RenderableEnum.forEnum(VerbosityDTO.class);
    }

    @JellyAccessible
    public RenderableEnum[] getChecksumModeValues() {
        return RenderableEnum.forEnum(ChecksumModeDTO.class);
    }

    @JellyAccessible
    public RenderableEnum[] getFailModeValues() {
        return RenderableEnum.forEnum(FailModeDTO.class);
    }

    @JellyAccessible
    public RenderableEnum[] getMakeModeValues() {
        return RenderableEnum.forEnum(MakeModeDTO.class);
    }

    @JellyAccessible
    public RenderableEnum[] getSnapshotUpdateModeValues() {
        return RenderableEnum.forEnum(SnapshotUpdateModeDTO.class);
    }

    @JellyAccessible
    public Collection<DocumentDTO> getSettingsDocuments() {
        return this.getDocuments(DocumentTypeDTO.SETTINGS);
    }

    @JellyAccessible
    public Collection<DocumentDTO> getToolChainsDocuments() {
        return this.getDocuments(DocumentTypeDTO.TOOLCHAINS);
    }

    private Collection<DocumentDTO> getDocuments(DocumentTypeDTO type) {
        Preconditions.checkNotNull((Object)type);
        return (Collection)this.security.callAs2(ACL.SYSTEM, (Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @JellyAccessible
    public boolean isSelected(Object value, Object configValue, Object defaultValue) {
        assert (value != null);
        return value.equals(configValue) || configValue == null && value.equals(defaultValue);
    }

    @JellyAccessible
    public Object valueOf(Object value, Object defaultValue) {
        return value != null ? value : defaultValue;
    }

    @JellyAccessible
    public String valueOf(PropertiesDTO value, PropertiesDTO defaultValue) {
        return ModelUtil.renderProperties((PropertiesDTO)(value != null ? value : defaultValue));
    }

    @JellyAccessible
    public String valueOf(List<String> value, List<String> defaultValue) {
        return ModelUtil.renderList(value != null ? value : defaultValue);
    }

    @JellyAccessible
    public MavenInstallation[] getInstallations() {
        return ((MavenInstallation.DescriptorImpl)Preconditions.checkNotNull((Object)this.installationDescriptor)).getInstallations();
    }

    public boolean configure(StaplerRequest req, JSONObject data) throws Descriptor.FormException {
        this.setDefaults(this.createConfiguration(data));
        return true;
    }

    public Builder newInstance(StaplerRequest req, JSONObject data) throws Descriptor.FormException {
        return new MavenBuilder(this.createConfiguration(data));
    }

    private BuildConfigurationDTO createConfiguration(JSONObject data) {
        return new BuildConfigurationExtractor(data).extract();
    }

    static /* synthetic */ DocumentManager access$000(MavenBuilderDescriptor x0) {
        return x0.documents;
    }
}

