/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder.rest;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.hudsonci.maven.model.config.BuildConfigurationDTO;
import org.hudsonci.maven.plugin.builder.MavenBuilderService;
import org.hudsonci.rest.common.ProjectNameCodec;
import org.hudsonci.rest.common.RestPreconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Path(value="/plugin/maven3-plugin/builderConfig/{projectName}")
@Produces(value={"application/json", "application/xml"})
public class BuilderConfigResource {
    private final MavenBuilderService mavenBuilderService;
    private final ProjectNameCodec projectNameCodec;

    @Inject
    public BuilderConfigResource(MavenBuilderService mavenBuilderService, ProjectNameCodec projectNameCodec) {
        this.mavenBuilderService = (MavenBuilderService)Preconditions.checkNotNull((Object)mavenBuilderService);
        this.projectNameCodec = (ProjectNameCodec)Preconditions.checkNotNull((Object)projectNameCodec);
    }

    @GET
    public List<BuildConfigurationDTO> getBuilderConfigurations(@PathParam(value="projectName") String projectName) {
        RestPreconditions.checkProjectName((String)projectName);
        return this.mavenBuilderService.getBuilderConfigurations(this.projectNameCodec.decode(projectName));
    }

    @GET
    @Path(value="{index}")
    public BuildConfigurationDTO getBuilderConfiguration(@PathParam(value="projectName") String projectName, @PathParam(value="index") int index) {
        RestPreconditions.checkProjectName((String)projectName);
        RestPreconditions.checkBuilderIndex((int)index);
        return this.mavenBuilderService.getBuilderConfiguration(this.projectNameCodec.decode(projectName), index);
    }

    @PUT
    @Path(value="{index}")
    public void setBuilderConfiguration(@PathParam(value="projectName") String projectName, @PathParam(value="index") int index, BuildConfigurationDTO config) throws IOException {
        RestPreconditions.checkProjectName((String)projectName);
        RestPreconditions.checkBuilderIndex((int)index);
        Preconditions.checkNotNull((Object)config, BuildConfigurationDTO.class);
        this.mavenBuilderService.setBuilderConfiguration(projectName, index, config);
    }
}

