/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.configure.documents.internal;

import com.allen_sauer.gwt.log.client.Log;
import com.google.common.base.Preconditions;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionModel;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hudsonci.maven.model.config.DocumentAttributeDTO;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.Document;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.DocumentDetailPresenter;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.DocumentDetailView;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.DocumentManagerLiaison;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.event.DocumentAddedEvent;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.event.DocumentSelectedEvent;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.event.DocumentUpdatedEvent;

@Singleton
public class DocumentDetailPresenterImpl
implements DocumentDetailPresenter {
    private final DocumentDetailView view;
    private final DocumentManagerLiaison documentManagerLiaison;
    private final ListDataProvider<DocumentAttributeDTO> attributesDataProvider;
    private Document current;

    @Inject
    public DocumentDetailPresenterImpl(DocumentDetailView view, DocumentManagerLiaison documentManagerLiaison) {
        this.view = (DocumentDetailView)Preconditions.checkNotNull((Object)view);
        this.documentManagerLiaison = (DocumentManagerLiaison)Preconditions.checkNotNull((Object)documentManagerLiaison);
        view.setPresenter((DocumentDetailPresenter)this);
        this.attributesDataProvider = new ListDataProvider();
        view.getAttributesDataContainer().setSelectionModel((SelectionModel)new NoSelectionModel());
        this.attributesDataProvider.addDataDisplay(view.getAttributesDataContainer());
    }

    public DocumentDetailView getView() {
        return this.view;
    }

    public void setDocument(Document document) {
        this.current = document;
        if (document != null) {
            this.view.setId(document.getId());
            this.view.setType(document.getType());
            this.view.setName(document.getName());
            this.view.setDescription(document.getDescription());
            this.view.setContent(document.getContent());
            this.view.setNewDocument(document.isNew());
            this.attributesDataProvider.setList(document.getAttributes());
            this.view.asWidget().setVisible(true);
        } else {
            this.view.asWidget().setVisible(false);
        }
    }

    public void onDocumentSelected(DocumentSelectedEvent event) {
        Preconditions.checkNotNull((Object)event);
        Document document = event.getDocument();
        Log.debug((String)("Document selected: " + document));
        this.setDocument(document);
    }

    public void onDocumentUpdated(DocumentUpdatedEvent event) {
        Preconditions.checkNotNull((Object)event);
        Document document = event.getDocument();
        Log.debug((String)("Document updated: " + document));
        this.setDocument(document);
    }

    public void onDocumentAdded(DocumentAddedEvent event) {
        Preconditions.checkNotNull((Object)event);
        Document document = event.getDocument();
        Log.debug((String)("Document added: " + document));
        this.setDocument(document);
    }

    public void doSave() {
        Preconditions.checkNotNull((Object)this.current);
        this.current.setId(this.view.getId());
        this.current.setType(this.view.getType());
        this.current.setName(this.view.getName());
        this.current.setDescription(this.view.getDescription());
        this.current.setContent(this.view.getContent());
        this.documentManagerLiaison.save(this.current);
    }

    public void doCancel() {
        if (this.current == null) {
            return;
        }
        if (this.current.isNew()) {
            this.documentManagerLiaison.remove(this.current);
            this.view.clear();
            this.view.asWidget().setVisible(false);
            this.attributesDataProvider.getList().clear();
            this.current = null;
        } else {
            this.setDocument(this.current);
        }
    }
}

