/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.configure.documents.internal;

import com.allen_sauer.gwt.log.client.Log;
import com.google.common.base.Preconditions;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.fusesource.restygwt.client.MethodCallback;
import org.hudsonci.gwt.common.restygwt.ServiceFailureNotifier;
import org.hudsonci.gwt.common.waitdialog.WaitPresenter;
import org.hudsonci.gwt.icons.silk.SilkIcons;
import org.hudsonci.maven.model.config.DocumentDTO;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.Document;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.DocumentManagerLiaison;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.event.DocumentAddedEvent;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.event.DocumentRemovedEvent;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.event.DocumentUpdatedEvent;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.internal.DocumentDataProvider;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.internal.DocumentManagerLiaisonImpl;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.internal.DocumentRestService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DocumentManagerLiaisonImpl
implements DocumentManagerLiaison {
    private final EventBus eventBus;
    private final DocumentRestService documentRestService;
    private final DocumentDataProvider documentDataProvider;
    private final SilkIcons icons;
    private final WaitPresenter waitWidget;
    private final DocumentManagerLiaison.MessagesResource messages;
    private final ServiceFailureNotifier serviceFailureNotifier;

    @Inject
    public DocumentManagerLiaisonImpl(EventBus eventBus, DocumentRestService documentRestService, DocumentDataProvider documentDataProvider, SilkIcons icons, WaitPresenter waitWidget, ServiceFailureNotifier serviceFailureNotifier, DocumentManagerLiaison.MessagesResource messages) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.documentRestService = (DocumentRestService)Preconditions.checkNotNull((Object)documentRestService);
        this.documentDataProvider = (DocumentDataProvider)Preconditions.checkNotNull((Object)documentDataProvider);
        this.icons = (SilkIcons)Preconditions.checkNotNull((Object)icons);
        this.waitWidget = (WaitPresenter)Preconditions.checkNotNull((Object)waitWidget);
        this.serviceFailureNotifier = (ServiceFailureNotifier)Preconditions.checkNotNull((Object)serviceFailureNotifier);
        this.messages = (DocumentManagerLiaison.MessagesResource)Preconditions.checkNotNull((Object)messages);
    }

    public DocumentDataProvider getDataProvider() {
        return this.documentDataProvider;
    }

    private List<Document> wrap(List<DocumentDTO> source) {
        assert (source != null);
        ArrayList<Document> target = new ArrayList<Document>(source.size());
        for (DocumentDTO item : source) {
            target.add(this.wrap(item));
        }
        return target;
    }

    private Document wrap(DocumentDTO source) {
        assert (source != null);
        return new DocumentImpl(this, source, null);
    }

    public void fetchAll() {
        Log.debug((String)"Fetching all documents");
        this.waitWidget.startWaiting();
        this.documentRestService.getDocuments(false, (MethodCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Document create() {
        DocumentImpl document = new DocumentImpl(this, null);
        this.documentDataProvider.add((Document)document);
        Log.debug((String)("Created new document: " + document));
        return document;
    }

    public void save(Document document) {
        Preconditions.checkNotNull((Object)document);
        if (document.isNew()) {
            this.add(document);
        } else {
            this.update(document);
        }
    }

    public void add(Document document) {
        Preconditions.checkNotNull((Object)document);
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Adding document: " + document));
        }
        DocumentDTO data = ((DocumentImpl)document).get();
        this.waitWidget.startWaiting();
        this.documentRestService.addDocument(data, (MethodCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void fireDocumentAdded(Document document) {
        this.eventBus.fireEvent((GwtEvent)new DocumentAddedEvent(document));
    }

    public void update(Document document) {
        Preconditions.checkNotNull((Object)document);
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Updating document: " + document));
        }
        DocumentDTO data = ((DocumentImpl)document).get();
        this.waitWidget.startWaiting();
        this.documentRestService.updateDocument(data.getId(), data, (MethodCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void fireDocumentUpdated(Document document) {
        this.eventBus.fireEvent((GwtEvent)new DocumentUpdatedEvent(document));
    }

    public void remove(Document document) {
        Preconditions.checkNotNull((Object)document);
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Removing document: " + document));
        }
        if (document.isNew()) {
            this.documentDataProvider.remove(document);
            this.fireDocumentRemoved(document);
            return;
        }
        DocumentDTO data = ((DocumentImpl)document).get();
        this.waitWidget.startWaiting();
        this.documentRestService.removeDocument(data.getId(), (MethodCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void fireDocumentRemoved(Document document) {
        this.eventBus.fireEvent((GwtEvent)new DocumentRemovedEvent(document));
    }

    static /* synthetic */ List access$100(DocumentManagerLiaisonImpl x0, List x1) {
        return x0.wrap(x1);
    }

    static /* synthetic */ DocumentDataProvider access$200(DocumentManagerLiaisonImpl x0) {
        return x0.documentDataProvider;
    }

    static /* synthetic */ WaitPresenter access$300(DocumentManagerLiaisonImpl x0) {
        return x0.waitWidget;
    }

    static /* synthetic */ DocumentManagerLiaison.MessagesResource access$400(DocumentManagerLiaisonImpl x0) {
        return x0.messages;
    }

    static /* synthetic */ ServiceFailureNotifier access$500(DocumentManagerLiaisonImpl x0) {
        return x0.serviceFailureNotifier;
    }

    static /* synthetic */ void access$700(DocumentManagerLiaisonImpl x0, Document x1) {
        x0.fireDocumentAdded(x1);
    }

    static /* synthetic */ void access$800(DocumentManagerLiaisonImpl x0, Document x1) {
        x0.fireDocumentUpdated(x1);
    }

    static /* synthetic */ void access$900(DocumentManagerLiaisonImpl x0, Document x1) {
        x0.fireDocumentRemoved(x1);
    }

    static /* synthetic */ SilkIcons access$1000(DocumentManagerLiaisonImpl x0) {
        return x0.icons;
    }
}

