/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder.internal;

import com.google.common.base.Preconditions;
import hudson.FilePath;
import hudson.util.ClasspathBuilder;
import org.apache.commons.io.FilenameUtils;

public class PathNormalizer {
    private final Platform platform;

    public PathNormalizer(Platform platform) {
        this.platform = (Platform)((Object)Preconditions.checkNotNull((Object)((Object)platform)));
    }

    public String normalize(String path) {
        assert (path != null);
        switch (this.platform) {
            case UNIX: {
                return FilenameUtils.separatorsToUnix((String)path);
            }
            case WINDOWS: {
                return FilenameUtils.separatorsToWindows((String)path);
            }
        }
        throw new Error();
    }

    public FilePath normalize(FilePath path) {
        assert (path != null);
        String tmp = this.normalize(path.getRemote());
        return new FilePath(path.getChannel(), tmp);
    }

    public ClasspathBuilder normalize(ClasspathBuilder cp) {
        assert (cp != null);
        ClasspathBuilder target = new ClasspathBuilder();
        for (String path : cp) {
            target.add(this.normalize(path));
        }
        return target;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Platform {
        UNIX,
        WINDOWS;

    }
}

