/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.dependencymonitor;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Project;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.maven.plugin.dependencymonitor.DependencyMonitor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="maven-dependency-trigger")
public class DependencyTrigger
extends Trigger<AbstractProject> {
    private static final Logger log = LoggerFactory.getLogger(DependencyTrigger.class);

    @DataBoundConstructor
    public DependencyTrigger() {
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public AbstractProject getProject() {
        return (AbstractProject)this.job;
    }

    public void start(AbstractProject project, boolean newInstance) {
        super.start((Item)project, newInstance);
        this.getDescriptor().dependencyMonitor.subscribe(this.getProject());
    }

    public void stop() {
        this.getDescriptor().dependencyMonitor.unsubscribe(this.getProject());
    }

    @Named
    @Singleton
    @Typed(value={Descriptor.class})
    public static class DescriptorImpl
    extends TriggerDescriptor {
        private final DependencyMonitor dependencyMonitor;

        @Inject
        public DescriptorImpl(DependencyMonitor dependencyMonitor) {
            this.dependencyMonitor = (DependencyMonitor)Preconditions.checkNotNull((Object)dependencyMonitor);
        }

        public boolean isApplicable(Item item) {
            return item instanceof Project || item instanceof MatrixProject;
        }

        public String getDisplayName() {
            return "Build when Maven dependencies have been updated by Maven 3 integration";
        }
    }
}

