/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.documents.internal;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hudsonci.maven.model.config.DocumentDTO;
import org.hudsonci.maven.plugin.documents.DocumentStore;
import org.hudsonci.service.SystemService;
import org.hudsonci.utils.io.Closer;
import org.hudsonci.utils.marshal.Marshaller;
import org.hudsonci.utils.marshal.XStreamMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DocumentStoreImpl
implements DocumentStore {
    private static final Logger log = LoggerFactory.getLogger(DocumentStoreImpl.class);
    public static final String ROOT_PATH = "maven/documents";
    public static final String FILE_SUFFIX = ".xml";
    private File rootDir;
    private Marshaller marshaller;

    @Inject
    public DocumentStoreImpl(SystemService system) {
        Preconditions.checkNotNull((Object)system);
        XStream xs = new XStream();
        xs.setClassLoader(this.getClass().getClassLoader());
        xs.processAnnotations(DocumentDTO.class);
        this.setMarshaller((Marshaller)new XStreamMarshaller(xs));
        this.setRootDir(new File(system.getWorkingDirectory(), ROOT_PATH));
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(File dir) {
        this.rootDir = (File)Preconditions.checkNotNull((Object)dir);
        log.debug("Root directory: {}", (Object)dir);
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = (Marshaller)Preconditions.checkNotNull((Object)marshaller);
    }

    File fileFor(String id) {
        Preconditions.checkNotNull((Object)id);
        return new File(this.rootDir, String.format("%s%s", id, FILE_SUFFIX));
    }

    File fileFor(UUID id) {
        Preconditions.checkNotNull((Object)id);
        return this.fileFor(id.toString());
    }

    File fileFor(DocumentDTO document) {
        Preconditions.checkNotNull((Object)document);
        return this.fileFor(document.getId());
    }

    @Override
    public Collection<DocumentDTO> loadAll() throws IOException {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(DocumentStoreImpl.FILE_SUFFIX);
            }
        };
        ArrayList<DocumentDTO> documents = new ArrayList<DocumentDTO>();
        HashSet<String> ids = new HashSet<String>();
        if (this.rootDir.exists()) {
            log.debug("Loading documents from directory: {}", (Object)this.rootDir);
            for (File file : this.rootDir.listFiles(filter)) {
                DocumentDTO document = this.load(file);
                String id = document.getId();
                if (ids.contains(id)) {
                    log.warn("Duplicate document ID detected: {}", (Object)id);
                }
                ids.add(id);
                documents.add(document);
            }
        }
        return documents;
    }

    @Override
    public boolean contains(UUID id) {
        Preconditions.checkNotNull((Object)id);
        return this.fileFor(id).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentDTO load(File file) throws FileNotFoundException {
        DocumentDTO documentDTO;
        Preconditions.checkNotNull((Object)file);
        log.debug("Loading document from file: {}", (Object)file);
        if (!file.exists()) {
            throw new FileNotFoundException("Document file missing: " + file);
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            DocumentDTO document = (DocumentDTO)this.marshaller.unmarshal((Reader)reader);
            if (document.getContent() == null) {
                log.warn("Loaded document with no content");
            }
            documentDTO = document;
        }
        catch (Throwable throwable) {
            Closer.close((Closeable[])new Closeable[]{reader});
            throw throwable;
        }
        Closer.close((Closeable[])new Closeable[]{reader});
        return documentDTO;
    }

    @Override
    public DocumentDTO load(UUID id) throws IOException {
        Preconditions.checkNotNull((Object)id);
        return this.load(this.fileFor(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(DocumentDTO document) throws IOException {
        File dir;
        Preconditions.checkNotNull((Object)document);
        File file = this.fileFor(document);
        log.debug("Storing document to file: {}", (Object)file);
        if (document.getContent() == null) {
            log.warn("Storing document with no content");
        }
        if (!(dir = file.getParentFile()).exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory structure for document file: " + file);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            this.marshaller.marshal((Object)document, (Writer)writer);
        }
        catch (Throwable throwable) {
            Closer.close((Closeable[])new Closeable[]{writer});
            throw throwable;
        }
        Closer.close((Closeable[])new Closeable[]{writer});
    }

    @Override
    public void delete(DocumentDTO document) throws IOException {
        Preconditions.checkNotNull((Object)document);
        File file = this.fileFor(document);
        log.debug("Deleting document file: {}", (Object)file);
        if (file.exists()) {
            if (!file.delete()) {
                throw new IOException("Failed to delete document file: " + file);
            }
        } else {
            log.warn("Ignoring delete; document file missing: {}", (Object)file);
        }
    }
}

