/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal;

import com.google.common.base.Preconditions;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.fusesource.restygwt.client.Method;
import org.fusesource.restygwt.client.MethodCallback;
import org.hudsonci.gwt.common.restygwt.ServiceFailureNotifier;
import org.hudsonci.gwt.common.waitdialog.WaitPresenter;
import org.hudsonci.maven.model.state.ArtifactDTO;
import org.hudsonci.maven.model.state.BuildStatesDTO;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.BuildCoordinates;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.BuildInformationManager;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.BuildStateService;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.event.BuildStateLoadedEvent;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal.ArtifactDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class BuildInformationManagerImpl
implements BuildInformationManager {
    private final BuildStateService buildStateService;
    private final ArtifactDataProvider adp;
    private final EventBus eventBus;
    private final String projectName;
    private final int buildNumber;
    private final WaitPresenter waiter;
    private final ServiceFailureNotifier serviceFailureNotifier;

    @Inject
    public BuildInformationManagerImpl(BuildCoordinates buildCoordinates, BuildStateService buildStateService, EventBus eventBus, ArtifactDataProvider adp, WaitPresenter waiter, ServiceFailureNotifier serviceFailureNotifier) {
        Preconditions.checkNotNull((Object)buildCoordinates);
        this.projectName = buildCoordinates.getProjectName();
        this.buildNumber = buildCoordinates.getBuildnumber();
        this.buildStateService = (BuildStateService)Preconditions.checkNotNull((Object)buildStateService);
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.adp = (ArtifactDataProvider)((Object)Preconditions.checkNotNull((Object)((Object)adp)));
        this.waiter = (WaitPresenter)Preconditions.checkNotNull((Object)waiter);
        this.serviceFailureNotifier = (ServiceFailureNotifier)Preconditions.checkNotNull((Object)serviceFailureNotifier);
    }

    @Override
    public void refresh() {
        this.waiter.startWaiting();
        this.buildStateService.getBuildStates(this.projectName, this.buildNumber, new MethodCallback<BuildStatesDTO>(){

            public void onSuccess(Method method, BuildStatesDTO response) {
                BuildInformationManagerImpl.this.eventBus.fireEvent((GwtEvent)new BuildStateLoadedEvent(response));
                BuildInformationManagerImpl.this.waiter.stopWaiting();
            }

            public void onFailure(Method method, Throwable exception) {
                BuildInformationManagerImpl.this.serviceFailureNotifier.displayFailure("Failed to fetch build information.", method, exception);
            }
        });
    }

    @Override
    public Collection<ArtifactDTO> getConsumedArtifacts(String moduleId) {
        HashSet<ArtifactDTO> consumedArtifacts = new HashSet<ArtifactDTO>();
        for (ArtifactDTO artifact : this.adp.getList()) {
            for (String dependendentModule : artifact.getDependentProjects()) {
                if (!moduleId.equals(dependendentModule)) continue;
                consumedArtifacts.add(artifact);
            }
        }
        return consumedArtifacts;
    }

    @Override
    public Collection<ArtifactDTO> getProducedArtifacts(String moduleId) {
        HashSet<ArtifactDTO> producedArtifacts = new HashSet<ArtifactDTO>();
        for (ArtifactDTO artifact : this.adp.getList()) {
            if (!moduleId.equals(artifact.getCreatedProject())) continue;
            producedArtifacts.add(artifact);
        }
        return producedArtifacts;
    }
}

