/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal;

import com.google.common.base.Preconditions;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.cellview.client.AbstractHasData;
import com.google.gwt.user.cellview.client.AbstractPager;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hudsonci.maven.model.PropertiesDTO;
import org.hudsonci.maven.model.state.ArtifactDTO;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.BuildInfoResources;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.BuildSummaryPresenter;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.MainPanelPresenter;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.ModuleInfoPresenter;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal.ArtifactDataProvider;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal.ModuleDataProvider;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.widget.PropertiesTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class MainPanelViewImpl
extends Composite
implements MainPanelPresenter.MainPanelView {
    private static MainPanelUiBinder uiBinder = (MainPanelUiBinder)GWT.create(MainPanelUiBinder.class);
    @UiField
    Panel statePickerPanel;
    @UiField
    ListBox statePicker;
    @UiField
    Image refresh;
    @UiField
    TabLayoutPanel tabPanel;
    @UiField(provided=true)
    final BuildSummaryPresenter.BuildSummaryView summaryInfo;
    @UiField
    PropertiesTable versionInfo;
    @UiField
    PropertiesTable userInfo;
    @UiField
    PropertiesTable systemInfo;
    @UiField
    PropertiesTable environmentInfo;
    @UiField(provided=true)
    final ModuleInfoPresenter.ModuleInfoView moduleInfo;
    @UiField
    AbstractHasData<ArtifactDTO> artifactInfo;
    @UiField
    AbstractPager artifactPager;
    private MainPanelPresenter presenter;

    @Inject
    public MainPanelViewImpl(ModuleDataProvider mdp, ArtifactDataProvider adp, BuildSummaryPresenter.BuildSummaryView buildSummaryView, ModuleInfoPresenter.ModuleInfoView moduleInfoView) {
        this.summaryInfo = (BuildSummaryPresenter.BuildSummaryView)Preconditions.checkNotNull((Object)buildSummaryView);
        this.moduleInfo = moduleInfoView;
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.initRefresh();
        this.statePickerPanel.setVisible(false);
        this.initArtifactView(adp);
    }

    @Override
    public void setPresenter(MainPanelPresenter presenter) {
        this.presenter = presenter;
    }

    protected void onLoad() {
        this.statePicker.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                MainPanelViewImpl.this.presenter.buildStateSelected(MainPanelViewImpl.this.statePicker.getSelectedIndex());
            }
        });
    }

    @Override
    public void setFirstShownWidget(IsWidget widget) {
        this.tabPanel.selectTab(widget);
    }

    @Override
    public void setVersionData(List<PropertiesDTO.Entry> data) {
        this.versionInfo.setRowData(data);
    }

    @Override
    public void setUserData(List<PropertiesDTO.Entry> data) {
        this.userInfo.setRowData(data);
    }

    @Override
    public void setSystemData(List<PropertiesDTO.Entry> data) {
        this.systemInfo.setRowData(data);
    }

    @Override
    public void setEnvironmentData(List<PropertiesDTO.Entry> data) {
        this.environmentInfo.setRowData(data);
    }

    @Override
    public void setStateSelectionNames(List<String> stateNames) {
        Preconditions.checkNotNull(stateNames);
        this.statePicker.clear();
        for (String name : stateNames) {
            this.statePicker.addItem(name);
        }
    }

    @Override
    public void showStatePicker(int selectedIndex) {
        this.statePicker.setSelectedIndex(selectedIndex);
        this.statePickerPanel.setVisible(true);
    }

    @Override
    public void selectModuleInfo() {
        this.tabPanel.selectTab((IsWidget)this.moduleInfo);
    }

    private void initRefresh() {
        this.refresh.setResource(BuildInfoResources.INSTANCE.refresh());
        this.refresh.setAltText("Refresh information.");
        this.refresh.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                MainPanelViewImpl.this.presenter.refresh();
            }
        });
    }

    private void initArtifactView(ArtifactDataProvider adp) {
        adp.addDataDisplay((HasData)this.artifactInfo);
        this.artifactPager.setDisplay(this.artifactInfo);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @UiTemplate(value="MainPanelViewImpl.ui.xml")
    static interface MainPanelUiBinder
    extends UiBinder<Widget, MainPanelViewImpl> {
    }
}

