/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.configure.documents.internal;

import com.allen_sauer.gwt.log.client.Log;
import com.google.common.base.Preconditions;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.resources.client.ImageResource;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.fusesource.restygwt.client.Method;
import org.fusesource.restygwt.client.MethodCallback;
import org.hudsonci.gwt.common.UUID;
import org.hudsonci.gwt.common.restygwt.ServiceFailureNotifier;
import org.hudsonci.gwt.common.waitdialog.WaitPresenter;
import org.hudsonci.gwt.icons.silk.SilkIcons;
import org.hudsonci.maven.model.config.DocumentAttributeDTO;
import org.hudsonci.maven.model.config.DocumentDTO;
import org.hudsonci.maven.model.config.DocumentTypeDTO;
import org.hudsonci.maven.model.config.DocumentsDTO;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.Document;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.DocumentManagerLiaison;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.event.DocumentAddedEvent;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.event.DocumentRemovedEvent;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.event.DocumentUpdatedEvent;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.internal.DocumentDataProvider;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.internal.DocumentRestService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DocumentManagerLiaisonImpl
implements DocumentManagerLiaison {
    private final EventBus eventBus;
    private final DocumentRestService documentRestService;
    private final DocumentDataProvider documentDataProvider;
    private final SilkIcons icons;
    private final WaitPresenter waitWidget;
    private final DocumentManagerLiaison.MessagesResource messages;
    private final ServiceFailureNotifier serviceFailureNotifier;

    @Inject
    public DocumentManagerLiaisonImpl(EventBus eventBus, DocumentRestService documentRestService, DocumentDataProvider documentDataProvider, SilkIcons icons, WaitPresenter waitWidget, ServiceFailureNotifier serviceFailureNotifier, DocumentManagerLiaison.MessagesResource messages) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.documentRestService = (DocumentRestService)Preconditions.checkNotNull((Object)documentRestService);
        this.documentDataProvider = (DocumentDataProvider)((Object)Preconditions.checkNotNull((Object)((Object)documentDataProvider)));
        this.icons = (SilkIcons)Preconditions.checkNotNull((Object)icons);
        this.waitWidget = (WaitPresenter)Preconditions.checkNotNull((Object)waitWidget);
        this.serviceFailureNotifier = (ServiceFailureNotifier)Preconditions.checkNotNull((Object)serviceFailureNotifier);
        this.messages = (DocumentManagerLiaison.MessagesResource)Preconditions.checkNotNull((Object)messages);
    }

    public DocumentDataProvider getDataProvider() {
        return this.documentDataProvider;
    }

    private List<Document> wrap(List<DocumentDTO> source) {
        assert (source != null);
        ArrayList<Document> target = new ArrayList<Document>(source.size());
        for (DocumentDTO item : source) {
            target.add(this.wrap(item));
        }
        return target;
    }

    private Document wrap(DocumentDTO source) {
        assert (source != null);
        return new DocumentImpl(source);
    }

    @Override
    public void fetchAll() {
        Log.debug((String)"Fetching all documents");
        this.waitWidget.startWaiting();
        this.documentRestService.getDocuments(false, new MethodCallback<DocumentsDTO>(){

            public void onSuccess(Method method, DocumentsDTO result) {
                Log.debug((String)("Received response to all documents; status=" + method.getResponse().getStatusText()));
                DocumentManagerLiaisonImpl.this.documentDataProvider.set(DocumentManagerLiaisonImpl.this.wrap(result.getDocuments()));
                DocumentManagerLiaisonImpl.this.waitWidget.stopWaiting();
            }

            public void onFailure(Method method, Throwable exception) {
                DocumentManagerLiaisonImpl.this.serviceFailureNotifier.displayFailure(DocumentManagerLiaisonImpl.this.messages.documentFetchAllFailed(), method, exception);
            }
        });
    }

    @Override
    public Document create() {
        DocumentImpl document = new DocumentImpl();
        this.documentDataProvider.add(document);
        Log.debug((String)("Created new document: " + document));
        return document;
    }

    @Override
    public void save(Document document) {
        Preconditions.checkNotNull((Object)document);
        if (document.isNew()) {
            this.add(document);
        } else {
            this.update(document);
        }
    }

    @Override
    public void add(final Document document) {
        Preconditions.checkNotNull((Object)document);
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Adding document: " + document));
        }
        DocumentDTO data = ((DocumentImpl)document).get();
        this.waitWidget.startWaiting();
        this.documentRestService.addDocument(data, new MethodCallback<DocumentDTO>(){

            public void onSuccess(Method method, DocumentDTO result) {
                Log.debug((String)("Added document: " + document));
                ((DocumentImpl)document).updateAttributes(result);
                ((DocumentImpl)document).setNew(false);
                DocumentManagerLiaisonImpl.this.documentDataProvider.refresh();
                DocumentManagerLiaisonImpl.this.fireDocumentAdded(document);
                DocumentManagerLiaisonImpl.this.waitWidget.stopWaiting();
            }

            public void onFailure(Method method, Throwable exception) {
                DocumentManagerLiaisonImpl.this.serviceFailureNotifier.displayFailure(DocumentManagerLiaisonImpl.this.messages.documentAddFailed(), method, exception);
            }
        });
    }

    private void fireDocumentAdded(Document document) {
        this.eventBus.fireEvent((GwtEvent)new DocumentAddedEvent(document));
    }

    @Override
    public void update(final Document document) {
        Preconditions.checkNotNull((Object)document);
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Updating document: " + document));
        }
        DocumentDTO data = ((DocumentImpl)document).get();
        this.waitWidget.startWaiting();
        this.documentRestService.updateDocument(data.getId(), data, new MethodCallback<DocumentDTO>(){

            public void onSuccess(Method method, DocumentDTO result) {
                Log.debug((String)("Updated document: " + document));
                ((DocumentImpl)document).updateAttributes(result);
                ((DocumentImpl)document).setDirty(false);
                DocumentManagerLiaisonImpl.this.documentDataProvider.refresh();
                DocumentManagerLiaisonImpl.this.fireDocumentUpdated(document);
                DocumentManagerLiaisonImpl.this.waitWidget.stopWaiting();
            }

            public void onFailure(Method method, Throwable exception) {
                DocumentManagerLiaisonImpl.this.serviceFailureNotifier.displayFailure(DocumentManagerLiaisonImpl.this.messages.documentUpdateFailed(), method, exception);
            }
        });
    }

    private void fireDocumentUpdated(Document document) {
        this.eventBus.fireEvent((GwtEvent)new DocumentUpdatedEvent(document));
    }

    @Override
    public void remove(final Document document) {
        Preconditions.checkNotNull((Object)document);
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Removing document: " + document));
        }
        if (document.isNew()) {
            this.documentDataProvider.remove(document);
            this.fireDocumentRemoved(document);
            return;
        }
        DocumentDTO data = ((DocumentImpl)document).get();
        this.waitWidget.startWaiting();
        this.documentRestService.removeDocument(data.getId(), new MethodCallback<String>(){

            public void onSuccess(Method method, String response) {
                Log.debug((String)("Removed document: " + document));
                DocumentManagerLiaisonImpl.this.documentDataProvider.remove(document);
                DocumentManagerLiaisonImpl.this.fireDocumentRemoved(document);
                DocumentManagerLiaisonImpl.this.waitWidget.stopWaiting();
            }

            public void onFailure(Method method, Throwable exception) {
                DocumentManagerLiaisonImpl.this.serviceFailureNotifier.displayFailure(DocumentManagerLiaisonImpl.this.messages.documentRemoveFailed(), method, exception);
            }
        });
    }

    private void fireDocumentRemoved(Document document) {
        this.eventBus.fireEvent((GwtEvent)new DocumentRemovedEvent(document));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DocumentImpl
    implements Document {
        private DocumentDTO data;
        private boolean isNew;
        private boolean dirty;

        private DocumentImpl(DocumentDTO data) {
            this.data = (DocumentDTO)Preconditions.checkNotNull((Object)data);
        }

        private DocumentImpl() {
            this(new DocumentDTO().withId(UUID.uuid()));
            this.setNew(true);
        }

        @Override
        public void setId(String value) {
            this.data.setId(value);
            this.setDirty(true);
        }

        @Override
        public String getId() {
            return this.data.getId();
        }

        @Override
        public void setType(DocumentTypeDTO value) {
            this.data.setType(value);
            this.setDirty(true);
        }

        @Override
        public DocumentTypeDTO getType() {
            if (this.data.getType() == null) {
                return DocumentTypeDTO.SETTINGS;
            }
            return this.data.getType();
        }

        @Override
        public void setName(String value) {
            this.data.setName(value);
            this.setDirty(true);
        }

        @Override
        public String getName() {
            return this.data.getName();
        }

        @Override
        public void setDescription(String value) {
            this.data.setDescription(value);
            this.setDirty(true);
        }

        @Override
        public String getDescription() {
            return this.data.getDescription();
        }

        @Override
        public void setContent(String value) {
            this.data.setContent(value);
            this.setDirty(true);
        }

        @Override
        public String getContent() {
            return this.data.getContent();
        }

        @Override
        public List<DocumentAttributeDTO> getAttributes() {
            return this.data.getAttributes();
        }

        public DocumentDTO get() {
            return this.data;
        }

        @Override
        public boolean isNew() {
            return this.isNew;
        }

        public void setNew(boolean flag) {
            this.isNew = flag;
            this.setDirty(flag);
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        @Override
        public ImageResource getIcon() {
            ImageResource icon = this.isNew() ? DocumentManagerLiaisonImpl.this.icons.page_white_add() : (this.isDirty() ? DocumentManagerLiaisonImpl.this.icons.page_white_edit() : DocumentManagerLiaisonImpl.this.icons.page_white());
            return icon;
        }

        @Override
        public String getDisplayName() {
            if (this.getName() != null && this.getName().trim().length() != 0) {
                return this.getName() + " (" + this.getId() + ")";
            }
            return this.getId();
        }

        public void updateAttributes(DocumentDTO source) {
            Preconditions.checkNotNull((Object)source);
            this.data.getAttributes().clear();
            this.data.getAttributes().addAll(source.getAttributes());
        }

        public int hashCode() {
            return this.data.getId().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != DocumentImpl.class) {
                return false;
            }
            DocumentImpl that = (DocumentImpl)obj;
            return that.get().getId().equals(this.data.getId());
        }

        public String toString() {
            return "DocumentImpl{id=" + this.data.getId() + ",type=" + this.data.getType() + ",name=" + this.data.getName() + ",new=" + this.isNew + ",dirty=" + this.dirty + ",attributes=" + this.data.getAttributes() + '}';
        }
    }
}

