/**
 * The MIT License
 *
 * Copyright (c) 2010-2011 Sonatype, Inc. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package org.hudsonci.maven.plugin.ui.gwt.configure.workspace.internal;

import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.TabLayoutPanel;

import javax.inject.Singleton;

import org.hudsonci.maven.plugin.ui.gwt.configure.workspace.WorkspaceManagerPresenter;
import org.hudsonci.maven.plugin.ui.gwt.configure.workspace.WorkspaceManagerView;
import org.hudsonci.maven.plugin.ui.gwt.configure.workspace.WorkspaceView;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Default implementation of {@link WorkspaceManagerView}.
 *
 * @author <a href="mailto:jason@planet57.com">Jason Dillon</a>
 * @since 2.1.0
 */
@Singleton
public class WorkspaceManagerViewImpl
    extends ResizeComposite
    implements WorkspaceManagerView
{
    private final TabLayoutPanel tabPanel;

    private WorkspaceManagerPresenter presenter;

    public WorkspaceManagerViewImpl() {
        tabPanel = new TabLayoutPanel(2.0, Unit.EM);
        tabPanel.setSize("100%", "100%");
        initWidget(tabPanel);
        ensureDebugId("workspace-manager-view");
    }

    public void setPresenter(final WorkspaceManagerPresenter presenter) {
        this.presenter = checkNotNull(presenter);
    }

    public void add(final WorkspaceView view) {
        tabPanel.add(view.asWidget(), view.getWorkspaceTitle());
    }
}
