/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.artifactrecorder.internal;

import com.google.common.base.Preconditions;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hudsonci.maven.model.state.ArtifactDTO;
import org.hudsonci.maven.model.state.ArtifactDTOHelper;
import org.hudsonci.maven.plugin.artifactrecorder.internal.DigestRecord;
import org.hudsonci.utils.common.TestAccessible;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestCollector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DigestCollector.class);
    private final Set<ArtifactDTO> artifacts;
    private final transient AbstractBuild build;

    public DigestCollector(AbstractBuild build, Set<ArtifactDTO> artifacts) {
        this.build = (AbstractBuild)Preconditions.checkNotNull((Object)build);
        this.artifacts = (Set)Preconditions.checkNotNull(artifacts);
        log.debug("Configured to collect {} artifacts from build {}", (Object)artifacts.size(), (Object)build);
    }

    public List<DigestRecord> collect() throws IOException, InterruptedException {
        FilePath workspace = this.build.getWorkspace();
        if (null == workspace) {
            throw new IOException("Missing node to collect artifact digests from.");
        }
        return (List)workspace.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @TestAccessible
    List<DigestRecord> collectFromNode() throws InterruptedException {
        log.debug("Collecting digests for {} artifacts", (Object)this.artifacts.size());
        ArrayList<DigestRecord> digests = new ArrayList<DigestRecord>(this.artifacts.size());
        for (ArtifactDTO artifact : this.artifacts) {
            String digest = null;
            File file = ArtifactDTOHelper.getFile((ArtifactDTO)artifact);
            String filename = null;
            if (file != null) {
                try {
                    digest = new FilePath(file).digest();
                    filename = file.getName();
                }
                catch (IOException e) {
                    log.error("Digest calculation failed: {}", (Object)file, (Object)e);
                }
            }
            digests.add(new DigestRecord(artifact, filename, digest));
        }
        return digests;
    }
}

