/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder.internal;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MavenVersionParser {
    private static final Pattern MAVEN_VERSION = Pattern.compile("(?i).*Maven [^0-9]*([0-9]\\S*).*");

    public String parse(BufferedReader reader) throws IOException {
        String line;
        Preconditions.checkNotNull((Object)reader);
        while ((line = reader.readLine()) != null) {
            Matcher m = MAVEN_VERSION.matcher(line);
            if (!m.matches()) continue;
            return m.group(1);
        }
        return null;
    }

    public String parse(String text) throws IOException {
        Preconditions.checkNotNull((Object)text);
        return this.parse(new BufferedReader(new StringReader(text)));
    }
}

