/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui;

import com.google.common.base.Preconditions;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Item;
import hudson.security.Permission;
import javax.inject.Inject;
import org.hudsonci.inject.injecto.Injectable;
import org.hudsonci.maven.plugin.builder.MavenBuildAction;
import org.hudsonci.rest.common.ProjectNameCodec;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.hudsonci.utils.plugin.ui.UIComponentSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenBuildUI
extends UIComponentSupport<MavenBuildAction>
implements Injectable {
    private ProjectNameCodec projectNameCodec;

    public MavenBuildUI(MavenBuildAction parent) {
        super((Action)parent);
    }

    @Inject
    public void setProjectNameCodec(ProjectNameCodec projectNameCodec) {
        this.projectNameCodec = (ProjectNameCodec)Preconditions.checkNotNull((Object)projectNameCodec);
    }

    public String getDisplayName() {
        return "Maven 3";
    }

    public String getUrlName() {
        return "maven";
    }

    public String getIconFileName() {
        return this.getIconFileName("maven-icon-24x24.png");
    }

    public Object getSidePanelOwner() {
        return this;
    }

    public String getPageTitle() {
        return String.format("%s Maven 3 Build Information", this.getBuild().getFullDisplayName());
    }

    @JellyAccessible
    public AbstractBuild getBuild() {
        return ((MavenBuildAction)this.getParent()).getBuild();
    }

    @JellyAccessible
    public String getProjectName() {
        return this.projectNameCodec.encode(this.getBuild().getProject().getFullName());
    }

    @JellyAccessible
    public String getBuildNumber() {
        return String.valueOf(this.getBuild().getNumber());
    }

    public Permission getViewPermission() {
        return Item.READ;
    }

    protected void checkPermission(Permission perm) {
        this.getBuild().checkPermission(perm);
    }
}

