/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hudsonci.maven.model.state.MavenProjectDTO;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.ModuleInfoPickerPresenter;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.event.ModuleSelectedEvent;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal.ModuleDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ModuleInfoPickerPresenterImpl
implements ModuleInfoPickerPresenter {
    private final ModuleInfoPickerPresenter.ModuleInfoPickerView view;
    private final EventBus eventBus;
    private final ModuleDataProvider mdp;
    private final SingleSelectionModel<MavenProjectDTO> selectionModel;
    private String currentSelectionId;

    @Inject
    public ModuleInfoPickerPresenterImpl(ModuleInfoPickerPresenter.ModuleInfoPickerView view, EventBus eventBus, ModuleDataProvider mdp) {
        this.view = view;
        this.eventBus = eventBus;
        this.mdp = mdp;
        this.selectionModel = this.createSelectionModel();
    }

    public ModuleInfoPickerPresenter.ModuleInfoPickerView bind() {
        this.view.setSelectionModel((SelectionModel)this.selectionModel);
        this.view.setData(this.mdp);
        return this.view;
    }

    private SingleSelectionModel<MavenProjectDTO> createSelectionModel() {
        SingleSelectionModel moduleSelectionModel = new SingleSelectionModel(ModuleDataProvider.KEY_PROVIDER);
        moduleSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        return moduleSelectionModel;
    }

    public void selectModule(MavenProjectDTO module) {
        Log.debug((String)("Selecting module: " + module));
        this.selectionModel.setSelected((Object)module, true);
    }

    public void moduleSelected(MavenProjectDTO pickedModule) {
        if (pickedModule != null) {
            this.currentSelectionId = pickedModule.getId();
            Log.debug((String)("Module selected; updated currentSelectionId: " + this.currentSelectionId));
        } else {
            this.currentSelectionId = null;
            Log.debug((String)"Module deselected.");
        }
        this.eventBus.fireEvent((GwtEvent)new ModuleSelectedEvent(pickedModule));
    }

    public void refreshSelection() {
        if (this.currentSelectionId != null) {
            try {
                this.moduleSelected(this.mdp.find(this.currentSelectionId));
                Log.debug((String)("Refreshing selection to previously selected moduleId: " + this.currentSelectionId));
            }
            catch (NoSuchElementException e) {
                MavenProjectDTO selected = (MavenProjectDTO)this.selectionModel.getSelectedObject();
                Log.debug((String)("Deselecting previously selected module: " + selected.getId()));
                this.selectionModel.setSelected((Object)selected, false);
            }
        }
    }
}

