/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.configure.documents.internal;

import com.google.common.base.Preconditions;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hudsonci.gwt.common.ImageTextButton;
import org.hudsonci.gwt.common.MaximizedCellTable;
import org.hudsonci.gwt.common.TogglePanel;
import org.hudsonci.gwt.common.ToolBar;
import org.hudsonci.gwt.icons.silk.SilkIcons;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.Document;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.DocumentDetailView;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.DocumentMasterPresenter;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.DocumentMasterView;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.internal.DocumentMasterViewImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DocumentMasterViewImpl
extends ResizeComposite
implements DocumentMasterView {
    private final DocumentMasterView.MessagesResource messages;
    private final ImageTextButton refreshButton;
    private final ImageTextButton addButton;
    private final ImageTextButton removeButton;
    private final CellTable<Document> documentsTable;
    private final ScrollPanel documentsTableScroller;
    private final TogglePanel detailContainer;
    private DocumentMasterPresenter presenter;

    @Inject
    public DocumentMasterViewImpl(DocumentMasterView.MessagesResource messages, SilkIcons icons) {
        this.messages = (DocumentMasterView.MessagesResource)Preconditions.checkNotNull((Object)messages);
        Preconditions.checkNotNull((Object)icons);
        DockLayoutPanel dockPanel = new DockLayoutPanel(Style.Unit.EM);
        this.initWidget((Widget)dockPanel);
        this.ensureDebugId("document-master-view");
        ToolBar toolBar = new ToolBar();
        toolBar.setSize("100%", "100%");
        dockPanel.addNorth((Widget)toolBar, 2.5);
        this.refreshButton = new ImageTextButton(icons.arrow_refresh(), messages.refresh());
        this.refreshButton.setTitle(messages.refresh());
        this.refreshButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        toolBar.add((Button)this.refreshButton);
        this.addButton = new ImageTextButton(icons.add(), messages.add());
        this.addButton.setTitle(messages.add());
        this.addButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        toolBar.add((Button)this.addButton);
        this.removeButton = new ImageTextButton(icons.delete(), messages.remove());
        this.removeButton.setTitle(messages.remove());
        this.removeButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.removeButton.setEnabled(false);
        toolBar.add((Button)this.removeButton);
        SplitLayoutPanel splitPanel = new SplitLayoutPanel();
        dockPanel.add((Widget)splitPanel);
        this.documentsTable = new MaximizedCellTable(100, Document.KEY_PROVIDER);
        this.documentsTable.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        4 iconColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.documentsTable.addColumn((Column)iconColumn);
        5 idColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.documentsTable.addColumn((Column)idColumn, messages.id());
        6 typeColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.documentsTable.addColumn((Column)typeColumn, messages.type());
        7 nameColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.documentsTable.addColumn((Column)nameColumn, messages.name());
        this.documentsTableScroller = new ScrollPanel();
        this.documentsTableScroller.setSize("100%", "100%");
        this.documentsTableScroller.setWidget((Widget)this.documentsTable);
        splitPanel.addNorth((Widget)this.documentsTableScroller, 200.0);
        this.detailContainer = new TogglePanel();
        this.detailContainer.setSize("100%", "100%");
        this.detailContainer.setSummary(messages.detailSummary());
        splitPanel.add((Widget)this.detailContainer);
    }

    public void setPresenter(DocumentMasterPresenter presenter) {
        this.presenter = (DocumentMasterPresenter)Preconditions.checkNotNull((Object)presenter);
    }

    public String getWorkspaceTitle() {
        return this.messages.documents();
    }

    public HasData<Document> getDocumentDataContainer() {
        return this.documentsTable;
    }

    public void setDocumentDetailView(DocumentDetailView view) {
        Widget widget = view.asWidget();
        widget.setSize("100%", "100%");
        widget.setVisible(false);
        this.detailContainer.setDetail((IsWidget)widget);
    }

    public void setDocumentSelected(boolean flag) {
        this.removeButton.setEnabled(flag);
        if (flag) {
            this.detailContainer.showDetail();
        } else {
            this.detailContainer.showSummary();
        }
    }

    public void scrollToNewDocument() {
        this.documentsTableScroller.scrollToBottom();
    }

    static /* synthetic */ DocumentMasterPresenter access$000(DocumentMasterViewImpl x0) {
        return x0.presenter;
    }
}

