/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.artifactrecorder.internal;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Fingerprint;
import hudson.model.FingerprintMap;
import hudson.tasks.BuildStep;
import hudson.tasks.Fingerprinter;
import hudson.tasks.Messages;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hudsonci.maven.model.MavenCoordinatesDTOHelper;
import org.hudsonci.maven.model.state.ArtifactDTO;
import org.hudsonci.maven.model.state.ArtifactDTOHelper;
import org.hudsonci.maven.plugin.artifactrecorder.ArtifactFingerprinter;
import org.hudsonci.maven.plugin.artifactrecorder.internal.DigestCollector;
import org.hudsonci.maven.plugin.artifactrecorder.internal.DigestRecord;
import org.hudsonci.utils.common.Varargs;
import org.hudsonci.utils.tasks.PerformOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformFingerprinting
extends PerformOperation<ArtifactFingerprinter> {
    private final Set<ArtifactDTO> artifacts;
    private final FingerprintMap registry;
    private final int numberOfBuilders;

    public PerformFingerprinting(ArtifactFingerprinter owner, AbstractBuild build, Launcher launcher, BuildListener listener, int numberOfBuilders, Set<ArtifactDTO> artifacts, FingerprintMap registry) {
        super((BuildStep)owner, build, launcher, listener);
        this.numberOfBuilders = numberOfBuilders;
        this.artifacts = artifacts;
        this.registry = registry;
    }

    protected boolean doExecute() throws Exception {
        if (this.artifacts.isEmpty()) {
            this.muxlog.info("No artifacts to fingerprint.");
            return true;
        }
        this.muxlog.info("Recording Maven 3 artifact fingerprints.");
        FilePath workspace = this.build.getWorkspace();
        if (null == workspace) {
            this.muxlog.error("Missing workspace to record fingerprints from.");
            return true;
        }
        HashMap<String, String> recordedFingerprints = new HashMap<String, String>(this.artifacts.size());
        try {
            List<DigestRecord> digests = new DigestCollector(this.build, this.artifacts).collect();
            this.recordFingerprints(this.build, digests, recordedFingerprints);
        }
        catch (IOException e) {
            this.muxlog.error("Fingerprinting failed.", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.muxlog.error("Fingerprinting aborted.", (Throwable)e);
        }
        this.muxlog.info("Recorded Maven 3 artifact fingerprints: {} files of {} build artifacts for {} Maven builders.", Varargs.va((Object[])new Integer[]{recordedFingerprints.size(), this.artifacts.size(), this.numberOfBuilders}));
        if (!recordedFingerprints.isEmpty()) {
            Fingerprinter.FingerprintAction.add((AbstractBuild)this.build, recordedFingerprints);
        }
        return true;
    }

    private void recordFingerprints(AbstractBuild build, List<DigestRecord> digests, Map<String, String> recordedFingerprints) throws IOException {
        for (DigestRecord digestRecord : digests) {
            String digest = digestRecord.getDigest();
            ArtifactDTO artifact = digestRecord.getArtifact();
            File file = ArtifactDTOHelper.getFile((ArtifactDTO)artifact);
            if (null == digest) {
                this.muxlog.debug("{} at {}", (Object)Messages.Fingerprinter_FailedFor((Object)artifact.getCoordinates()), (Object)file);
                continue;
            }
            String fileIdentifier = String.format("%s [%s]", artifact.getCoordinates().toString(MavenCoordinatesDTOHelper.RenderStyle.GATCV_OPTIONAL), digestRecord.getFilename());
            Fingerprint fingerprint = this.registry.getOrCreate(this.maybeMadeByThisBuild(artifact), fileIdentifier, digest);
            fingerprint.add(build);
            recordedFingerprints.put(fileIdentifier, fingerprint.getHashString());
        }
    }

    private AbstractBuild maybeMadeByThisBuild(ArtifactDTO artifact) {
        return artifact.getCreatedProject() == null ? null : this.build;
    }
}

