/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.maven.model.config.BuildConfigurationDTO;
import org.hudsonci.maven.model.state.BuildStateDTO;
import org.hudsonci.maven.plugin.builder.BuildStateNotFoundException;
import org.hudsonci.maven.plugin.builder.BuildStateRecord;
import org.hudsonci.maven.plugin.builder.BuilderConfigurationNotFoundException;
import org.hudsonci.maven.plugin.builder.MavenBuilder;
import org.hudsonci.maven.plugin.builder.MavenBuilderDescriptor;
import org.hudsonci.maven.plugin.builder.MavenBuilderService;
import org.hudsonci.service.BuildService;
import org.hudsonci.service.DescriptorService;
import org.hudsonci.service.ProjectService;
import org.hudsonci.service.SecurityService;
import org.hudsonci.utils.tasks.MetaProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class MavenBuilderServiceImpl
implements MavenBuilderService {
    private static final Logger log = LoggerFactory.getLogger(MavenBuilderServiceImpl.class);
    private final SecurityService security;
    private final DescriptorService descriptors;
    private final ProjectService projects;
    private final BuildService builds;

    @Inject
    public MavenBuilderServiceImpl(SecurityService security, DescriptorService descriptors, ProjectService projects, BuildService builds) {
        this.security = (SecurityService)Preconditions.checkNotNull((Object)security);
        this.descriptors = (DescriptorService)Preconditions.checkNotNull((Object)descriptors);
        this.projects = (ProjectService)Preconditions.checkNotNull((Object)projects);
        this.builds = (BuildService)Preconditions.checkNotNull((Object)builds);
    }

    private MavenBuilderDescriptor getMavenBuilderDescriptor() {
        return (MavenBuilderDescriptor)this.descriptors.getDescriptorByType(MavenBuilderDescriptor.class);
    }

    @Override
    public BuildConfigurationDTO getBuilderDefaultConfiguration() {
        this.security.checkPermission(Hudson.ADMINISTER);
        return this.getMavenBuilderDescriptor().getDefaults();
    }

    @Override
    public void setBuilderDefaultConfiguration(BuildConfigurationDTO defaults) {
        Preconditions.checkNotNull((Object)defaults);
        this.security.checkPermission(Hudson.ADMINISTER);
        log.debug("Set builder default config: {}", (Object)defaults);
        this.getMavenBuilderDescriptor().setDefaults(defaults);
    }

    @Override
    public void resetBuilderDefaultConfiguration() {
        this.security.checkPermission(Hudson.ADMINISTER);
        log.debug("Reset builder default config");
        this.getMavenBuilderDescriptor().setDefaults(MavenBuilderDescriptor.DEFAULTS);
    }

    @Override
    public List<BuildConfigurationDTO> getBuilderConfigurations(String projectName) {
        Preconditions.checkNotNull((Object)projectName);
        log.debug("Fetching builder configs: {}", (Object)projectName);
        MetaProject project = new MetaProject(this.projects.getProject(projectName));
        project.checkPermission(Item.CONFIGURE);
        List builders = project.getBuildersList().getAll(MavenBuilder.class);
        ArrayList configs = Lists.newArrayListWithCapacity((int)builders.size());
        for (MavenBuilder builder : builders) {
            configs.add(builder.getConfig());
        }
        return configs;
    }

    @Override
    public BuildConfigurationDTO getBuilderConfiguration(String projectName, int index) {
        Preconditions.checkNotNull((Object)projectName);
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
        log.debug("Fetching builder config: {} [{}]", (Object)projectName, (Object)index);
        List<BuildConfigurationDTO> configs = this.getBuilderConfigurations(projectName);
        try {
            return configs.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new BuilderConfigurationNotFoundException(projectName, index);
        }
    }

    @Override
    public void setBuilderConfiguration(String projectName, int index, BuildConfigurationDTO config) throws IOException {
        Preconditions.checkNotNull((Object)projectName);
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)config);
        log.debug("Setting builder config: {} [{}]", (Object)projectName, (Object)index);
        MetaProject project = new MetaProject(this.projects.getProject(projectName));
        project.checkPermission(Item.CONFIGURE);
        ArrayList builders = Lists.newArrayList();
        int i = 0;
        boolean found = false;
        for (Builder builder : project.getBuilders()) {
            if (builder instanceof MavenBuilder) {
                if (i == index) {
                    builder = new MavenBuilder(config);
                    found = true;
                }
                ++i;
            }
            builders.add(builder);
        }
        if (!found) {
            throw new BuilderConfigurationNotFoundException(projectName, index);
        }
        project.getBuildersList().replaceBy((Collection)builders);
    }

    @Override
    public List<BuildStateDTO> getBuildStates(String projectName, int buildNumber) {
        Preconditions.checkNotNull((Object)projectName);
        Preconditions.checkArgument((buildNumber > 0 ? 1 : 0) != 0);
        log.debug("Fetching build states: {} #{}", (Object)projectName, (Object)buildNumber);
        AbstractBuild build = this.builds.getBuild(projectName, buildNumber);
        List<BuildStateDTO> states = this.getBuildStates(build);
        log.debug("Found {} build states", (Object)states.size());
        return states;
    }

    @Override
    public List<BuildStateDTO> getBuildStates(AbstractBuild build) {
        build.checkPermission(Item.READ);
        ArrayList states = Lists.newArrayList();
        for (BuildStateRecord record : build.getActions(BuildStateRecord.class)) {
            states.add(record.getState());
        }
        return states;
    }

    @Override
    public BuildStateDTO getBuildState(String projectName, int buildNumber, int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
        List<BuildStateDTO> states = this.getBuildStates(projectName, buildNumber);
        try {
            return states.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new BuildStateNotFoundException(projectName, buildNumber, index);
        }
    }
}

