/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder.internal.invoker;

import hudson.remoting.Channel;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.hudsonci.maven.eventspy.common.Callback;
import org.hudsonci.maven.plugin.builder.internal.invoker.Invoker;
import org.hudsonci.maven.plugin.builder.internal.invoker.MethodKey;
import org.hudsonci.utils.common.Varargs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.gossip.support.DC;

public class InvokerImpl
implements Invoker,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(InvokerImpl.class);
    private final Object target;
    private final Class targetType;
    private final AtomicInteger counter = new AtomicInteger(0);
    private static final Map<MethodKey, Method> methodLookup = new HashMap<MethodKey, Method>();

    public InvokerImpl(Object target) {
        assert (target != null);
        this.target = target;
        this.targetType = target.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarshalledObject invoke(MethodKey key, MarshalledObject[] margs) throws Throwable {
        assert (key != null);
        DC.put(InvokerImpl.class, (Object)this.counter.getAndIncrement());
        boolean trace = log.isTraceEnabled();
        try {
            MarshalledObject<Object> marshalledObject;
            Object result;
            Method method;
            Object[] args = null;
            if (margs != null) {
                args = new Object[margs.length];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = margs[i].get();
                }
            }
            if ((method = methodLookup.get(key)) == null) {
                log.error("Missing method for key: {}", (Object)key);
                throw new Error(String.format("Missing method for key: %s", key));
            }
            log.trace("Selected: {}", (Object)method);
            try {
                result = method.invoke(this.target, args);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                log.error("Invocation threw exception", cause);
                throw cause;
            }
            catch (Throwable t) {
                log.error("Invoke failed", t);
                throw t;
            }
            if (trace) {
                log.trace("Result:");
                if (result != null) {
                    Class<?> vtype = result.getClass();
                    log.trace("  {} ({}@{})", Varargs.$((Object[])new Object[]{result, vtype, vtype.hashCode()}));
                } else {
                    log.trace("  null");
                }
            }
            if (result != null && result.getClass() != Void.TYPE) {
                marshalledObject = new MarshalledObject<Object>(result);
                return marshalledObject;
            }
            marshalledObject = null;
            return marshalledObject;
        }
        finally {
            DC.remove(InvokerImpl.class);
        }
    }

    private Object writeReplace() {
        return Channel.current().export(Invoker.class, (Object)this);
    }

    static {
        log.trace("Method lookup:");
        for (Method method : Callback.class.getDeclaredMethods()) {
            MethodKey key = new MethodKey(method);
            methodLookup.put(key, method);
            log.trace("  {} -> {}", (Object)key, (Object)method);
        }
    }
}

