/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder.internal.invoker;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.hudsonci.maven.model.InvocationDTO;
import org.hudsonci.maven.plugin.builder.internal.invoker.DelegatingInvocationHandler;
import org.hudsonci.utils.io.Closer;

public class RecordingHandler
extends DelegatingInvocationHandler {
    public static final String INVOCATION_STREAM = "invocation-stream";
    private final XStream xs;
    private final File file;
    private final Writer writer;
    private final ObjectOutputStream output;

    public RecordingHandler(InvocationHandler delegate, File file) throws IOException {
        super(delegate);
        assert (file != null);
        this.file = file;
        this.log.debug("Recording invocations to: {}", (Object)file);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.xs = new XStream();
        this.xs.autodetectAnnotations(true);
        this.writer = new BufferedWriter(new FileWriter(file));
        this.output = this.xs.createObjectOutputStream(this.writer, INVOCATION_STREAM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object value;
        assert (method != null);
        InvocationDTO.Result result = new InvocationDTO.Result();
        InvocationDTO invocation = this.invocationOf(method, args).withResult(result);
        try {
            value = this.getDelegate().invoke(proxy, method, args);
            result.withException(false).withValue(value);
        }
        catch (Throwable t) {
            result.withException(true).withValue((Object)t);
            throw t;
        }
        finally {
            try {
                ObjectOutputStream objectOutputStream = this.output;
                synchronized (objectOutputStream) {
                    this.output.writeObject(invocation);
                }
            }
            catch (IOException e) {
                this.log.error("Write object failed", (Throwable)e);
            }
        }
        return value;
    }

    private InvocationDTO invocationOf(Method method, Object[] args) {
        assert (method != null);
        InvocationDTO.Method imethod = new InvocationDTO.Method().withName(method.getName());
        for (Class<?> type : method.getParameterTypes()) {
            imethod.getTypes().add(type.getName());
        }
        return new InvocationDTO().withMethod(imethod).withArgs(args);
    }

    public void close() {
        Closer.close((Closeable[])new Closeable[]{this.output});
    }
}

