/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.documents.rest;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.hudsonci.maven.model.config.DocumentDTO;
import org.hudsonci.maven.model.config.DocumentsDTO;
import org.hudsonci.maven.plugin.documents.DocumentManager;
import org.hudsonci.rest.common.RestPreconditions;

@Named
@Path(value="/plugin/maven3-plugin/documents")
@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
public class DocumentResource {
    private final DocumentManager documents;

    @Inject
    public DocumentResource(DocumentManager documents) {
        this.documents = (DocumentManager)Preconditions.checkNotNull((Object)documents);
    }

    @GET
    @Consumes
    public DocumentsDTO getDocuments(@QueryParam(value="summary") @DefaultValue(value="false") boolean summary) {
        return new DocumentsDTO().withDocuments(this.documents.getDocuments(summary));
    }

    @POST
    public DocumentDTO addDocument(DocumentDTO document) {
        RestPreconditions.checkNotNull((Object)document, (String)"Document");
        return this.documents.addDocument(document);
    }

    @GET
    @Path(value="{id}")
    @Consumes
    public DocumentDTO getDocument(@PathParam(value="id") String id, @QueryParam(value="summary") @DefaultValue(value="false") boolean summary) {
        RestPreconditions.checkDocumentId((String)id);
        return this.documents.getDocument(id, summary);
    }

    @PUT
    @Path(value="{id}")
    public DocumentDTO updateDocument(@PathParam(value="id") String id, DocumentDTO document) {
        RestPreconditions.checkDocumentId((String)id);
        RestPreconditions.checkNotNull((Object)document, DocumentDTO.class);
        if (!id.equals(document.getId())) {
            RestPreconditions.throwConflict((String)String.format("Document ID mismatch: %s != %s", id, document.getId()));
        }
        return this.documents.updateDocument(document);
    }

    @DELETE
    @Path(value="{id}")
    @Produces
    @Consumes
    public void removeDocument(@PathParam(value="id") String id) {
        RestPreconditions.checkDocumentId((String)id);
        this.documents.removeDocument(id);
    }
}

