/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.artifactrecorder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.HashSet;
import org.hudsonci.maven.plugin.artifactrecorder.ArtifactArchiver;
import org.hudsonci.maven.plugin.artifactrecorder.internal.PerformArchiving;
import org.hudsonci.maven.plugin.builder.BuildStateRecord;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.kohsuke.stapler.DataBoundConstructor;

@XStreamAlias(value="maven-artifact-archiver")
public class ArtifactArchiver
extends Recorder {
    private final boolean includePomArtifacts;
    private final boolean deleteOldArchiveArtifacts;

    @DataBoundConstructor
    public ArtifactArchiver(boolean includePomArtifacts, boolean deleteOldArchiveArtifacts) {
        this.includePomArtifacts = includePomArtifacts;
        this.deleteOldArchiveArtifacts = deleteOldArchiveArtifacts;
    }

    @JellyAccessible
    public boolean isIncludePomArtifacts() {
        return this.includePomArtifacts;
    }

    @JellyAccessible
    public boolean isDeleteOldArchiveArtifacts() {
        return this.deleteOldArchiveArtifacts;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (Result.ABORTED == build.getResult()) {
            return true;
        }
        HashSet artifacts = new HashSet();
        for (BuildStateRecord record : build.getActions(BuildStateRecord.class)) {
            artifacts.addAll(record.getState().getArtifacts());
        }
        return new PerformArchiving(this, build, launcher, listener, artifacts, this.includePomArtifacts, this.deleteOldArchiveArtifacts).execute();
    }
}

