/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder.internal;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hudsonci.maven.model.MavenCoordinatesDTO;
import org.hudsonci.maven.model.state.ArtifactDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactRegistry {
    private static final Logger log = LoggerFactory.getLogger(ArtifactRegistry.class);
    private final Map<MavenCoordinatesDTO, ArtifactDTO> map = new HashMap(1000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordArtifact(ArtifactDTO artifact) {
        if (artifact == null) {
            log.warn("Artifact is null");
            return;
        }
        if (artifact.getCoordinates() == null) {
            log.warn("Artifact coordinates are null");
            return;
        }
        ArtifactRegistry artifactRegistry = this;
        synchronized (artifactRegistry) {
            ArtifactDTO entry = this.get(artifact.getCoordinates());
            if (entry == null) {
                entry = new ArtifactDTO().withCoordinates(artifact.getCoordinates());
            }
            if (!this.isMetaVersionExpanded(entry) && this.isMetaVersionExpanded(artifact)) {
                entry.getCoordinates().withExpandedMetaVersion(artifact.getCoordinates().getExpandedMetaVersion());
            }
            if (entry.getType() == null && artifact.getType() != null) {
                entry.withType(artifact.getType());
            }
            if (entry.getRepositoryFile() == null && artifact.getRepositoryFile() != null) {
                entry.withRepositoryFile(artifact.getRepositoryFile());
            }
            if (entry.getCreatedProject() == null && artifact.getCreatedProject() != null) {
                entry.withCreatedProject(artifact.getCreatedProject());
            }
            entry.withActions((Collection)artifact.getActions());
            entry.withConsumingProjects((Collection)artifact.getConsumingProjects());
            entry.withDependentProjects((Collection)artifact.getDependentProjects());
            this.map.put(entry.getCoordinates(), entry);
        }
    }

    private boolean isMetaVersionExpanded(ArtifactDTO entry) {
        String expandedMetaVersion = entry.getCoordinates().getExpandedMetaVersion();
        return expandedMetaVersion != null && !expandedMetaVersion.endsWith("SNAPSHOT");
    }

    public Collection<ArtifactDTO> getAll() {
        return ImmutableList.copyOf(this.map.values());
    }

    public ArtifactDTO get(MavenCoordinatesDTO coordinates) {
        return (ArtifactDTO)this.map.get(coordinates);
    }
}

