/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder.rest;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.hudsonci.maven.model.state.BuildStateDTO;
import org.hudsonci.maven.model.state.BuildStatesDTO;
import org.hudsonci.maven.plugin.builder.BuildStateNotFoundException;
import org.hudsonci.maven.plugin.builder.MavenBuilderService;
import org.hudsonci.rest.common.ProjectNameCodec;
import org.hudsonci.rest.common.RestPreconditions;

@Named
@Path(value="/plugin/maven3-plugin/buildState/{projectName}/{buildNumber:\\d*}")
@Produces(value={"application/json", "application/xml"})
public class BuildStateResource {
    private final MavenBuilderService mavenBuilderService;
    private final ProjectNameCodec projectNameCodec;

    @Inject
    public BuildStateResource(MavenBuilderService mavenBuilderService, ProjectNameCodec projectNameCodec) {
        this.mavenBuilderService = (MavenBuilderService)Preconditions.checkNotNull((Object)mavenBuilderService);
        this.projectNameCodec = (ProjectNameCodec)Preconditions.checkNotNull((Object)projectNameCodec);
    }

    @GET
    public BuildStatesDTO getBuildStates(@PathParam(value="projectName") String projectName, @PathParam(value="buildNumber") int buildNumber) {
        RestPreconditions.checkProjectName((String)projectName);
        RestPreconditions.checkBuildNumber((int)buildNumber);
        List states = this.mavenBuilderService.getBuildStates(this.projectNameCodec.decode(projectName), buildNumber);
        if (states.isEmpty()) {
            throw new BuildStateNotFoundException(projectName, buildNumber);
        }
        return new BuildStatesDTO().withStates((Collection)states);
    }

    @GET
    @Path(value="{index}")
    public BuildStateDTO getBuildState(@PathParam(value="projectName") String projectName, @PathParam(value="buildNumber") int buildNumber, @PathParam(value="index") int index) {
        RestPreconditions.checkProjectName((String)projectName);
        RestPreconditions.checkBuildNumber((int)buildNumber);
        RestPreconditions.checkBuilderIndex((int)index);
        return this.mavenBuilderService.getBuildState(this.projectNameCodec.decode(projectName), buildNumber, index);
    }
}

