/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.dependencymonitor.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hudsonci.maven.model.MavenCoordinatesDTO;
import org.hudsonci.maven.model.state.ArtifactDTO;
import org.hudsonci.maven.plugin.builder.BuildStateRecord;
import org.hudsonci.maven.plugin.dependencymonitor.ArtifactsExtractor;
import org.hudsonci.maven.plugin.dependencymonitor.ArtifactsPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactsExtractorImpl
implements ArtifactsExtractor {
    private static final Logger log = LoggerFactory.getLogger(ArtifactsExtractorImpl.class);

    public ArtifactsPair extract(AbstractProject project) {
        Preconditions.checkNotNull((Object)project);
        if (project instanceof MatrixConfiguration) {
            return null;
        }
        AbstractBuild build = (AbstractBuild)project.getLastSuccessfulBuild();
        return build != null ? this.extract(build) : null;
    }

    public ArtifactsPair extract(AbstractBuild build) {
        Preconditions.checkNotNull((Object)build);
        if (build instanceof MatrixRun) {
            return null;
        }
        log.debug("Extracting artifacts from build: {}", (Object)build);
        HashSet produced = Sets.newHashSet();
        HashSet consumed = Sets.newHashSet();
        if (build instanceof MatrixBuild) {
            for (MatrixRun run : ((MatrixBuild)MatrixBuild.class.cast(build)).getRuns()) {
                log.debug("Including artifacts from multi-config run: {}", (Object)run);
                this.extractFromBuild((AbstractBuild)run, (Set)produced, (Set)consumed);
            }
        } else {
            this.extractFromBuild(build, (Set)produced, (Set)consumed);
        }
        consumed.removeAll(produced);
        return new ArtifactsPair((Collection)produced, (Collection)consumed);
    }

    private void extractFromBuild(AbstractBuild build, Set<MavenCoordinatesDTO> produced, Set<MavenCoordinatesDTO> consumed) {
        assert (build != null);
        assert (produced != null);
        assert (consumed != null);
        List records = build.getActions(BuildStateRecord.class);
        if (!records.isEmpty()) {
            for (BuildStateRecord record : records) {
                for (ArtifactDTO artifact : record.getState().getArtifacts()) {
                    if (artifact.getCreatedProject() != null) {
                        produced.add(artifact.getCoordinates());
                        continue;
                    }
                    consumed.add(artifact.getCoordinates());
                }
            }
        }
    }
}

