/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.dependencymonitor.internal;

import com.google.common.base.Preconditions;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.maven.plugin.dependencymonitor.DependencyMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class BuildArtifactsUpdater
extends RunListener<AbstractBuild> {
    private static final Logger log = LoggerFactory.getLogger(BuildArtifactsUpdater.class);
    private final DependencyMonitor dependencyMonitor;

    @Inject
    public BuildArtifactsUpdater(DependencyMonitor dependencyMonitor) {
        super(AbstractBuild.class);
        this.dependencyMonitor = (DependencyMonitor)Preconditions.checkNotNull((Object)dependencyMonitor);
    }

    public void onCompleted(AbstractBuild build, TaskListener listener) {
        assert (build != null);
        Result result = build.getResult();
        if (result.isWorseThan(Result.UNSTABLE)) {
            log.debug("Skipping artifact update for build: {} due to result: {}", (Object)build, (Object)result);
            return;
        }
        this.dependencyMonitor.update(build, listener);
    }
}

