/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.documents.internal;

import com.google.common.base.Preconditions;
import hudson.model.Hudson;
import hudson.model.User;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.maven.model.config.DocumentDTO;
import org.hudsonci.maven.model.config.DocumentStandardAttributeDTO;
import org.hudsonci.maven.model.config.DocumentTypeDTO;
import org.hudsonci.maven.plugin.documents.DocumentException;
import org.hudsonci.maven.plugin.documents.DocumentManager;
import org.hudsonci.maven.plugin.documents.DocumentNotFoundException;
import org.hudsonci.maven.plugin.documents.DocumentStore;
import org.hudsonci.maven.plugin.documents.DuplicateDocumentException;
import org.hudsonci.service.SecurityService;
import org.hudsonci.utils.common.Iso8601Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class DocumentManagerImpl
implements DocumentManager {
    private static final Logger log = LoggerFactory.getLogger(DocumentManagerImpl.class);
    private final Map<UUID, DocumentDTO> documents = new LinkedHashMap();
    private final DocumentStore store;
    private final SecurityService security;

    @Inject
    public DocumentManagerImpl(DocumentStore store, SecurityService security) {
        this.store = (DocumentStore)Preconditions.checkNotNull((Object)store);
        this.security = (SecurityService)Preconditions.checkNotNull((Object)security);
        try {
            for (DocumentDTO document : store.loadAll()) {
                this.validate(document);
                this.documents.put(this.idFor(document), document);
            }
        }
        catch (IOException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    String getCurrentUserId() {
        User user = this.security.getCurrentUser();
        if (user == null) {
            user = this.security.getUnknownUser();
        }
        return user.getId();
    }

    String now() {
        return Iso8601Date.format((Date)new Date());
    }

    String randomId() {
        return UUID.randomUUID().toString();
    }

    UUID idFor(String id) {
        Preconditions.checkNotNull((Object)id);
        return UUID.fromString(id);
    }

    UUID idFor(DocumentDTO document) {
        Preconditions.checkNotNull((Object)document);
        return this.idFor(document.getId());
    }

    void validate(DocumentDTO document) {
        Preconditions.checkNotNull((Object)document);
        Preconditions.checkNotNull((Object)document.getId(), (Object)"Missing document ID");
        this.idFor(document.getId());
        Preconditions.checkNotNull((Object)document.getType(), (Object)"Missing document type");
    }

    DocumentDTO copyOf(DocumentDTO document) {
        Preconditions.checkNotNull((Object)document);
        return new DocumentDTO().withId(document.getId()).withType(document.getType()).withName(document.getName()).withDescription(document.getDescription()).withAttributes((Collection)document.getAttributes()).withContent(document.getContent());
    }

    DocumentDTO summaryOf(DocumentDTO document) {
        return this.copyOf(document).withContent(null);
    }

    public synchronized Collection<DocumentDTO> getDocuments(boolean summary) {
        log.debug("Get documents w/summary={}", (Object)summary);
        this.security.checkPermission(Hudson.ADMINISTER);
        ArrayList<DocumentDTO> result = new ArrayList<DocumentDTO>(this.documents.size());
        for (DocumentDTO document : this.documents.values()) {
            result.add(summary ? this.summaryOf(document) : document);
        }
        return result;
    }

    public synchronized Collection<DocumentDTO> getDocuments(DocumentTypeDTO type, boolean summary) {
        Preconditions.checkNotNull((Object)type);
        log.debug("Get documents w/type={}, w/summary={}", (Object)type, (Object)summary);
        this.security.checkPermission(Hudson.ADMINISTER);
        ArrayList<DocumentDTO> result = new ArrayList<DocumentDTO>();
        for (DocumentDTO document : this.documents.values()) {
            if (!type.equals((Object)document.getType())) continue;
            result.add(summary ? this.summaryOf(document) : document);
        }
        return result;
    }

    public synchronized DocumentDTO addDocument(DocumentDTO document) {
        Object id;
        Preconditions.checkNotNull((Object)document);
        log.debug("Adding document: {}", (Object)document);
        this.security.checkPermission(Hudson.ADMINISTER);
        if (document.getId() == null) {
            id = this.randomId();
            document.setId((String)id);
            log.debug("Generated ID for new document: {}", id);
        }
        this.validate(document);
        id = this.idFor(document);
        if (this.documents.containsKey(id)) {
            throw new DuplicateDocumentException((UUID)id);
        }
        document.setAttribute((Object)DocumentStandardAttributeDTO.CREATED, (Object)this.now());
        document.setAttribute((Object)DocumentStandardAttributeDTO.CREATED_BY, (Object)this.getCurrentUserId());
        try {
            this.store.store(document);
        }
        catch (IOException e) {
            throw new DocumentException((Throwable)e);
        }
        this.documents.put(id, document);
        return this.summaryOf(document);
    }

    private synchronized DocumentDTO getDocument(UUID id, boolean summary) {
        Preconditions.checkNotNull((Object)id);
        log.debug("Get document w/id={}, w/summary={}", (Object)id, (Object)summary);
        this.security.checkPermission(Hudson.ADMINISTER);
        DocumentDTO document = (DocumentDTO)this.documents.get(id);
        if (document == null) {
            throw new DocumentNotFoundException(id);
        }
        return summary ? this.summaryOf(document) : document;
    }

    public synchronized DocumentDTO getDocument(String id, boolean summary) {
        return this.getDocument(this.idFor(id), summary);
    }

    public synchronized DocumentDTO updateDocument(DocumentDTO document) {
        Preconditions.checkNotNull((Object)document);
        log.debug("Update document: {}", (Object)document);
        this.security.checkPermission(Hudson.ADMINISTER);
        this.validate(document);
        UUID id = this.idFor(document);
        if (!this.documents.containsKey(id)) {
            throw new DocumentNotFoundException(id);
        }
        document.setAttribute((Object)DocumentStandardAttributeDTO.UPDATED, (Object)this.now());
        document.setAttribute((Object)DocumentStandardAttributeDTO.UPDATED_BY, (Object)this.getCurrentUserId());
        try {
            this.store.store(document);
        }
        catch (IOException e) {
            throw new DocumentException((Throwable)e);
        }
        this.documents.put(id, document);
        return this.summaryOf(document);
    }

    private synchronized void removeDocument(UUID id) {
        Preconditions.checkNotNull((Object)id);
        log.debug("Remove document w/id={}", (Object)id);
        this.security.checkPermission(Hudson.ADMINISTER);
        DocumentDTO document = (DocumentDTO)this.documents.remove(id);
        if (document == null) {
            throw new DocumentNotFoundException(id);
        }
        try {
            this.store.delete(document);
        }
        catch (IOException e) {
            throw new DocumentException((Throwable)e);
        }
    }

    public synchronized void removeDocument(String id) {
        this.removeDocument(this.idFor(id));
    }
}

