/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.buildinfo;

import com.allen_sauer.gwt.log.client.Log;
import com.google.common.base.Preconditions;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.HasWidgets;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hudsonci.maven.model.state.BuildStateDTO;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.BuildInformationManager;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.BuildSummaryPresenter;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.MainPanelPresenter;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.ModuleInfoPickerPresenter;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.ModuleInfoPresenter;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.event.BuildStateLoadedEvent;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.event.BuildStateSelectedEvent;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.event.ModuleSelectedEvent;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal.ArtifactDataProvider;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal.ModuleDataProvider;

@Singleton
public class MavenBuildInfoController {
    private final MainPanelPresenter mainPanel;
    private final BuildInformationManager manager;
    private final EventBus eventBus;
    private final ModuleDataProvider mdp;
    private final ArtifactDataProvider adp;
    private final BuildSummaryPresenter buildSummaryPresenter;
    private final ModuleInfoPresenter moduleInfoPresenter;
    private final ModuleInfoPickerPresenter moduleInfoPickerPresenter;

    @Inject
    public MavenBuildInfoController(MainPanelPresenter mainPanel, BuildInformationManager buildInformationManager, EventBus eventBus, ModuleDataProvider mdp, ArtifactDataProvider adp, BuildSummaryPresenter buildSummaryPresenter, ModuleInfoPresenter moduleInfoPresenter, ModuleInfoPickerPresenter moduleInfoPickerPresenter) {
        this.mainPanel = mainPanel;
        this.manager = buildInformationManager;
        this.eventBus = eventBus;
        this.mdp = mdp;
        this.adp = adp;
        this.buildSummaryPresenter = (BuildSummaryPresenter)Preconditions.checkNotNull((Object)buildSummaryPresenter);
        this.moduleInfoPresenter = moduleInfoPresenter;
        this.moduleInfoPickerPresenter = moduleInfoPickerPresenter;
    }

    public void start(HasWidgets container) {
        this.eventBus.addHandler(ModuleSelectedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(BuildStateLoadedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(BuildStateSelectedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.mainPanel.bind(container);
        this.manager.refresh();
    }

    public void buildStateSelected(BuildStateSelectedEvent event) {
        BuildStateDTO buildState = event.getBuildState();
        this.mdp.setList(buildState.getParticipatingProjects());
        this.adp.setList(buildState.getArtifacts());
        this.buildSummaryPresenter.setBuildState(buildState);
        this.moduleInfoPickerPresenter.refreshSelection();
        Log.debug((String)("Refreshed data; mdp:" + this.mdp.getList().size() + " adp:" + this.adp.getList().size()));
    }

    private void startHistoryManagement() {
        History.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        History.fireCurrentHistoryState();
    }

    static /* synthetic */ ModuleInfoPresenter access$000(MavenBuildInfoController x0) {
        return x0.moduleInfoPresenter;
    }

    static /* synthetic */ MainPanelPresenter access$100(MavenBuildInfoController x0) {
        return x0.mainPanel;
    }

    static /* synthetic */ ModuleDataProvider access$200(MavenBuildInfoController x0) {
        return x0.mdp;
    }

    static /* synthetic */ ModuleInfoPickerPresenter access$300(MavenBuildInfoController x0) {
        return x0.moduleInfoPickerPresenter;
    }
}

