/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.buildinfo;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.resources.client.ImageResource;
import java.util.Date;
import java.util.List;
import org.hudsonci.maven.model.state.BuildResultDTO;
import org.hudsonci.maven.model.state.MavenProjectDTO;
import org.hudsonci.maven.model.state.ProfileDTO;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.BuildInfoResources;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.ModuleFormatter;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.ModuleInspector;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModuleFormatter {
    private final MavenProjectDTO module;

    public ModuleFormatter(MavenProjectDTO module) {
        this.module = module;
    }

    public String duration() {
        StringBuilder sb = new StringBuilder();
        if (ModuleInspector.hasDuration((MavenProjectDTO)this.module)) {
            sb.append(ModuleFormatter.formatTime((long)this.module.getBuildSummary().getDuration()));
        }
        return sb.toString();
    }

    public String profiles() {
        List profiles = this.module.getProfiles();
        StringBuilder sb = new StringBuilder();
        if (0 == profiles.size()) {
            sb.append("none");
        } else {
            for (ProfileDTO profile : profiles) {
                sb.append(profile.getId()).append(" ");
            }
            sb.append("(total: ").append(profiles.size()).append(")");
        }
        return sb.toString();
    }

    public String profiles(boolean activeOnly) {
        List profiles = this.module.getProfiles();
        StringBuilder sb = new StringBuilder();
        if (0 == profiles.size()) {
            sb.append("none");
        } else {
            int counted = 0;
            for (ProfileDTO profile : profiles) {
                if (!activeOnly) {
                    sb.append(profile.getId()).append(" ");
                    ++counted;
                    continue;
                }
                if (!profile.isActive()) continue;
                sb.append(profile.getId()).append(" ");
                ++counted;
            }
            if (0 == counted) {
                sb.append("none");
            } else {
                sb.append("(total: ").append(counted).append(")");
            }
        }
        return sb.toString();
    }

    public ImageResource statusIcon(BuildInfoResources resources) {
        BuildResultDTO result = this.module.getBuildSummary().getResult();
        return ModuleFormatter.resolveStatusIcon((BuildInfoResources)resources, (BuildResultDTO)result);
    }

    public static ImageResource resolveStatusIcon(BuildInfoResources resources, BuildResultDTO result) {
        switch (1.$SwitchMap$org$hudsonci$maven$model$state$BuildResultDTO[result.ordinal()]) {
            case 1: {
                return resources.buildSuccessIcon();
            }
            case 2: {
                return resources.buildFailureIcon();
            }
            case 3: {
                return resources.buildDisabledIcon();
            }
            case 4: {
                return resources.activityScheduled();
            }
            case 5: {
                return resources.activityExecuting();
            }
        }
        return resources.buildDisabledIcon();
    }

    public static String formatTime(long time) {
        String pattern = "s.SSS's'";
        if (time / 60000L > 0L) {
            pattern = "m:s" + pattern;
            if (time / 3600000L > 0L) {
                pattern = "H:m" + pattern;
            }
        }
        return DateTimeFormat.getFormat((String)pattern).format(new Date(time));
    }
}

