/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.configure.documents.internal;

import com.google.common.base.Preconditions;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hudsonci.gwt.common.EnumListBox;
import org.hudsonci.gwt.common.MaximizedCellTable;
import org.hudsonci.maven.model.config.DocumentAttributeDTO;
import org.hudsonci.maven.model.config.DocumentTypeDTO;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.DocumentDetailPresenter;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.DocumentDetailView;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.internal.DocumentDetailViewImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DocumentDetailViewImpl
extends ResizeComposite
implements DocumentDetailView {
    private final DocumentDetailView.MessagesResource messages;
    private final TextBox idText;
    private final EnumListBox<DocumentTypeDTO> typeBox;
    private final TextBox nameText;
    private final TextArea descriptionText;
    private final CellTable<DocumentAttributeDTO> attributesTable;
    private final TextArea contentText;
    private final Button saveButton;
    private final Button cancelButton;
    private DocumentDetailPresenter presenter;

    @Inject
    public DocumentDetailViewImpl(DocumentDetailView.MessagesResource messages) {
        this.messages = (DocumentDetailView.MessagesResource)Preconditions.checkNotNull((Object)messages);
        DockLayoutPanel dockPanel = new DockLayoutPanel(Style.Unit.EM);
        this.initWidget((Widget)dockPanel);
        this.ensureDebugId("document-detail-view");
        int row = 0;
        FlexTable fieldsTable = new FlexTable();
        fieldsTable.setWidth("100%");
        fieldsTable.setCellSpacing(4);
        fieldsTable.setCellPadding(0);
        dockPanel.addNorth((Widget)fieldsTable, 20.0);
        Label idLabel = new Label(messages.id());
        idLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        fieldsTable.setWidget(row, 0, (Widget)idLabel);
        this.idText = new TextBox();
        this.idText.setWidth("100%");
        this.idText.setReadOnly(true);
        fieldsTable.setWidget(row, 1, (Widget)this.idText);
        Label typeLabel = new Label(messages.type());
        typeLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        fieldsTable.setWidget(++row, 0, (Widget)typeLabel);
        this.typeBox = new EnumListBox(DocumentTypeDTO.class, (Enum)DocumentTypeDTO.SETTINGS);
        fieldsTable.setWidget(row, 1, (Widget)this.typeBox);
        Label nameLabel = new Label(messages.name());
        nameLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        fieldsTable.setWidget(++row, 0, (Widget)nameLabel);
        this.nameText = new TextBox();
        this.nameText.setWidth("100%");
        fieldsTable.setWidget(row, 1, (Widget)this.nameText);
        Label descriptionLabel = new Label(messages.description());
        descriptionLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        fieldsTable.setWidget(++row, 0, (Widget)descriptionLabel);
        this.descriptionText = new TextArea();
        this.descriptionText.setWidth("100%");
        this.descriptionText.setVisibleLines(4);
        fieldsTable.setWidget(row, 1, (Widget)this.descriptionText);
        Label attributesLabel = new Label(messages.attributes());
        attributesLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        fieldsTable.setWidget(++row, 0, (Widget)attributesLabel);
        this.attributesTable = new MaximizedCellTable(10);
        this.attributesTable.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        1 nameColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.attributesTable.addColumn((Column)nameColumn);
        2 valueColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.attributesTable.addColumn((Column)valueColumn);
        ScrollPanel attributesTableScroller = new ScrollPanel();
        attributesTableScroller.setSize("100%", "100%");
        attributesTableScroller.setWidget((Widget)this.attributesTable);
        fieldsTable.setWidget(row, 1, (Widget)attributesTableScroller);
        this.contentText = new TextArea();
        this.contentText.setSize("100%", "100%");
        ScrollPanel contentScroller = new ScrollPanel();
        contentScroller.setSize("100%", "100%");
        contentScroller.setWidget((Widget)this.contentText);
        dockPanel.add((Widget)contentScroller);
        FlowPanel buttonPanel = new FlowPanel();
        buttonPanel.setSize("100%", "100%");
        dockPanel.addSouth((Widget)buttonPanel, 2.0);
        this.saveButton = new Button(messages.save());
        this.saveButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add((Widget)this.saveButton);
        this.cancelButton = new Button(messages.cancel());
        this.cancelButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        buttonPanel.add((Widget)this.cancelButton);
    }

    public void setPresenter(DocumentDetailPresenter presenter) {
        this.presenter = (DocumentDetailPresenter)Preconditions.checkNotNull((Object)presenter);
    }

    public void setId(String value) {
        this.idText.setText(value);
    }

    public String getId() {
        return this.idText.getText();
    }

    public void setType(DocumentTypeDTO value) {
        this.typeBox.setSelected((Enum)value);
    }

    public DocumentTypeDTO getType() {
        return (DocumentTypeDTO)this.typeBox.getSelected();
    }

    public void setName(String value) {
        this.nameText.setText(value);
    }

    public String getName() {
        return this.nameText.getText();
    }

    public void setDescription(String value) {
        this.descriptionText.setText(value);
    }

    public String getDescription() {
        return this.descriptionText.getText();
    }

    public HasData<DocumentAttributeDTO> getAttributesDataContainer() {
        return this.attributesTable;
    }

    public void setContent(String value) {
        this.contentText.setText(value);
    }

    public String getContent() {
        return this.contentText.getText();
    }

    public void setNewDocument(boolean flag) {
        if (flag) {
            this.saveButton.setText(this.messages.save());
            this.saveButton.setTitle(this.messages.save());
            this.cancelButton.setText(this.messages.cancel());
            this.cancelButton.setTitle(this.messages.cancel());
        } else {
            this.saveButton.setText(this.messages.update());
            this.saveButton.setTitle(this.messages.update());
            this.cancelButton.setText(this.messages.revert());
            this.cancelButton.setTitle(this.messages.revert());
        }
    }

    public void clear() {
        this.setId(null);
        this.setType(null);
        this.setName(null);
        this.setDescription(null);
        this.setContent(null);
    }

    static /* synthetic */ DocumentDetailPresenter access$000(DocumentDetailViewImpl x0) {
        return x0.presenter;
    }
}

