/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.artifactrecorder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.HashSet;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.maven.model.state.ArtifactDTO;
import org.hudsonci.maven.plugin.artifactrecorder.internal.PerformArchiving;
import org.hudsonci.maven.plugin.builder.BuildStateRecord;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.kohsuke.stapler.DataBoundConstructor;

@XStreamAlias(value="maven-artifact-archiver")
public class ArtifactArchiver
extends Recorder {
    private final boolean includePomArtifacts;
    private final boolean deleteOldArchiveArtifacts;

    @DataBoundConstructor
    public ArtifactArchiver(boolean includePomArtifacts, boolean deleteOldArchiveArtifacts) {
        this.includePomArtifacts = includePomArtifacts;
        this.deleteOldArchiveArtifacts = deleteOldArchiveArtifacts;
    }

    @JellyAccessible
    public boolean isIncludePomArtifacts() {
        return this.includePomArtifacts;
    }

    @JellyAccessible
    public boolean isDeleteOldArchiveArtifacts() {
        return this.deleteOldArchiveArtifacts;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (Result.ABORTED == build.getResult()) {
            return true;
        }
        HashSet<ArtifactDTO> artifacts = new HashSet<ArtifactDTO>();
        for (BuildStateRecord record : build.getActions(BuildStateRecord.class)) {
            artifacts.addAll(record.getState().getArtifacts());
        }
        return new PerformArchiving(this, build, launcher, listener, artifacts, this.includePomArtifacts, this.deleteOldArchiveArtifacts).execute();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Named
    @Singleton
    @Typed(value={Descriptor.class})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Archive Maven 3 artifacts";
        }
    }
}

