/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.artifactrecorder.internal;

import com.google.common.base.Preconditions;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStep;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.hudsonci.maven.model.MavenCoordinatesDTO;
import org.hudsonci.maven.model.state.ArtifactDTO;
import org.hudsonci.maven.model.state.ArtifactDTOHelper;
import org.hudsonci.maven.plugin.artifactrecorder.ArtifactArchiver;
import org.hudsonci.utils.common.Varargs;
import org.hudsonci.utils.tasks.PerformOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformArchiving
extends PerformOperation<ArtifactArchiver> {
    private static final String ARTIFACT_TYPE_POM = "pom";
    private final Set<ArtifactDTO> artifacts;
    private final boolean includePoms;
    private final boolean deleteOld;

    public PerformArchiving(ArtifactArchiver owner, AbstractBuild build, Launcher launcher, BuildListener listener, Set<ArtifactDTO> artifacts, boolean includePoms, boolean deleteOld) {
        super((BuildStep)owner, build, launcher, listener);
        this.artifacts = (Set)Preconditions.checkNotNull(artifacts);
        this.includePoms = includePoms;
        this.deleteOld = deleteOld;
    }

    protected boolean doExecute() throws Exception {
        if (this.deleteOld) {
            this.deleteOldBuildArtifacts();
        }
        if (this.artifacts.isEmpty()) {
            this.muxlog.info("No Maven 3 artifacts to archive.");
            return true;
        }
        this.muxlog.info("Archiving Maven 3 artifacts.");
        int count = this.archiveArtifacts(this.artifacts);
        this.muxlog.info("Archived Maven 3 artifacts: {}.", (Object)count);
        return true;
    }

    private int archiveArtifacts(Collection<ArtifactDTO> artifacts) {
        int count = 0;
        FilePath workspace = this.build.getWorkspace();
        if (null == workspace) {
            this.muxlog.error("Missing workspace to archive artifacts from.");
            return count;
        }
        try {
            FilePath archiveDirectory = new FilePath(this.build.getArtifactsDir());
            archiveDirectory.mkdirs();
            this.log.debug("Archiving to {}", (Object)archiveDirectory);
            VirtualChannel channel = workspace.getChannel();
            for (ArtifactDTO artifact : artifacts) {
                if (null == artifact.getCreatedProject() || !this.maybeIncludePom(artifact)) continue;
                MavenCoordinatesDTO gav = artifact.getCoordinates();
                File file = ArtifactDTOHelper.getFile((ArtifactDTO)artifact);
                if (file != null) {
                    FilePath source = new FilePath(channel, file.getPath());
                    FilePath target = archiveDirectory.child(gav.getGroupId()).child(gav.getArtifactId()).child(gav.getVersion()).child(source.getName());
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Created path to archive: {} on channel {}", (Object)target, (Object)target.getChannel());
                        this.log.trace("Copying FROM {} on channel {} TO {} on channel {}", Varargs.$((Object[])new Object[]{source, source.getChannel(), target, target.getChannel()}));
                    }
                    source.copyTo(target);
                    ++count;
                    continue;
                }
                this.muxlog.error("Failed to archive Maven 3 artifact {} - unresolved.", (Object)gav);
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)this.listener);
            this.muxlog.error("Failed to archive Maven 3 artifacts", (Throwable)e);
        }
        catch (InterruptedException e) {
            this.muxlog.error("Failed to archive Maven 3 artifacts", (Throwable)e);
        }
        return count;
    }

    private boolean maybeIncludePom(ArtifactDTO artifact) {
        if (this.includePoms) {
            return true;
        }
        return !ARTIFACT_TYPE_POM.equals(artifact.getCoordinates().getType());
    }

    private void deleteOldBuildArtifacts() {
        Result bestResultSoFar = Result.NOT_BUILT;
        for (AbstractBuild b = (AbstractBuild)this.build.getProject().getLastCompletedBuild(); b != null; b = (AbstractBuild)b.getPreviousBuild()) {
            if (b.getResult().isBetterThan(bestResultSoFar)) {
                bestResultSoFar = b.getResult();
                continue;
            }
            File ad = b.getArtifactsDir();
            if (!ad.exists()) continue;
            this.muxlog.info("Deleting old Maven artifacts from {}", (Object)b.getDisplayName());
            try {
                Util.deleteRecursive((File)ad);
                continue;
            }
            catch (IOException e) {
                this.muxlog.error("Failed to delete old Maven artifacts", (Throwable)e);
            }
        }
    }
}

