/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import net.sf.json.JSONObject;
import org.hudsonci.maven.model.ModelUtil;
import org.hudsonci.maven.model.PropertiesDTO;
import org.hudsonci.maven.model.config.BuildConfigurationDTO;
import org.hudsonci.maven.model.config.ChecksumModeDTO;
import org.hudsonci.maven.model.config.FailModeDTO;
import org.hudsonci.maven.model.config.MakeModeDTO;
import org.hudsonci.maven.model.config.SnapshotUpdateModeDTO;
import org.hudsonci.maven.model.config.VerbosityDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildConfigurationExtractor {
    private final JSONObject data;

    public BuildConfigurationExtractor(JSONObject data) {
        this.data = (JSONObject)Preconditions.checkNotNull((Object)data);
    }

    private String getString(String name) {
        return this.nullIfEmpty(this.data.getString(name));
    }

    private boolean getBoolean(String name) {
        return this.data.getBoolean(name);
    }

    private PropertiesDTO getProperties(String name) {
        return ModelUtil.parseProperties((String)this.data.getString(name));
    }

    private List<String> getList(String name) {
        return ModelUtil.parseList((String)this.nullIfEmpty(this.data.getString(name)));
    }

    private <E extends Enum<E>> E getEnum(Class<E> type, String name) {
        return Enum.valueOf(type, this.data.getString(name));
    }

    private String nullIfEmpty(String value) {
        if (value != null && value.trim().length() == 0) {
            return null;
        }
        return value;
    }

    private String nullIfEmptyOrNone(String value) {
        if (this.nullIfEmpty(value) == null || "NONE".equals(value)) {
            return null;
        }
        return value;
    }

    public BuildConfigurationDTO extract() {
        BuildConfigurationDTO config = new BuildConfigurationDTO();
        config.setInstallationId(this.getString("installationId"));
        config.setGoals(this.getString("goals"));
        config.setProperties(this.getProperties("properties"));
        config.setPomFile(this.getString("pomFile"));
        config.setPrivateRepository(Boolean.valueOf(this.getBoolean("privateRepository")));
        config.setPrivateTmpdir(Boolean.valueOf(this.getBoolean("privateTmpdir")));
        config.setOffline(Boolean.valueOf(this.getBoolean("offline")));
        config.setRecursive(Boolean.valueOf(this.getBoolean("recursive")));
        config.withProfiles(this.getList("profiles"));
        config.withProjects(this.getList("projects"));
        config.setResumeFrom(this.getString("resumeFrom"));
        config.setErrors(Boolean.valueOf(this.getBoolean("errors")));
        config.setVerbosity(this.getEnum(VerbosityDTO.class, "verbosity"));
        config.setChecksumMode(this.getEnum(ChecksumModeDTO.class, "checksumMode"));
        config.setFailMode(this.getEnum(FailModeDTO.class, "failMode"));
        config.setMakeMode(this.getEnum(MakeModeDTO.class, "makeMode"));
        config.setSnapshotUpdateMode(this.getEnum(SnapshotUpdateModeDTO.class, "snapshotUpdateMode"));
        config.setThreading(this.getString("threading"));
        config.setMavenOpts(this.getString("mavenOpts"));
        config.setSettingsId(this.getString("settingsId"));
        config.setGlobalSettingsId(this.getString("globalSettingsId"));
        config.setToolChainsId(this.getString("toolChainsId"));
        return config;
    }
}

