/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder.internal;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.slaves.Channels;
import hudson.tasks.BuildStep;
import hudson.util.VariableResolver;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.hudsonci.maven.model.PropertiesDTO;
import org.hudsonci.maven.model.state.BuildResultDTO;
import org.hudsonci.maven.model.state.BuildStateDTO;
import org.hudsonci.maven.model.state.BuildSummaryDTO;
import org.hudsonci.maven.model.state.ExecutionActivityDTO;
import org.hudsonci.maven.model.state.ExecutionActivityTypeDTO;
import org.hudsonci.maven.model.state.MavenProjectDTO;
import org.hudsonci.maven.plugin.builder.MavenBuilder;
import org.hudsonci.maven.plugin.builder.internal.CallbackImpl;
import org.hudsonci.maven.plugin.builder.internal.MavenInstallationValidator;
import org.hudsonci.maven.plugin.builder.internal.MavenProcessBuilder;
import org.hudsonci.maven.plugin.builder.internal.StartProcessing;
import org.hudsonci.maven.plugin.install.BundledMavenInstallation;
import org.hudsonci.maven.plugin.install.MavenInstallation;
import org.hudsonci.utils.tasks.OpenServerSocket;
import org.hudsonci.utils.tasks.PerformOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformBuild
extends PerformOperation<MavenBuilder> {
    private static final List<BuildResultDTO> INCOMPLETE_STATES = Collections.unmodifiableList(Arrays.asList(null, BuildResultDTO.SCHEDULED, BuildResultDTO.BUILDING, BuildResultDTO.UNKNOWN));
    private final BuildStateDTO state;

    public PerformBuild(MavenBuilder owner, BuildStateDTO state, AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        super((BuildStep)owner, build, launcher, listener);
        this.state = state;
    }

    protected boolean doExecute() throws Exception {
        OpenServerSocket.Connection connection;
        final EnvVars env = this.build.getEnvironment((TaskListener)this.listener);
        final VariableResolver vr = this.build.getBuildVariableResolver();
        MavenProcessBuilder builder = new MavenProcessBuilder(this.muxlog){

            protected String resolve(String value) {
                assert (value != null);
                value = Util.replaceMacro((String)value, (VariableResolver)vr);
                value = env.expand(value);
                value = value.replaceAll("[\t\r\n]+", " ");
                return value;
            }
        };
        MavenInstallation installation = ((MavenBuilder)this.owner).getMavenInstallation();
        if (installation == null) {
            this.muxlog.info("Using bundled Maven 3 installation");
            installation = new BundledMavenInstallation();
        } else {
            this.muxlog.info("Using Maven 3 installation: {}", (Object)installation.getName());
            installation = installation.forNode(((MavenBuilder)this.owner).getNodes().getCurrentNode(), (TaskListener)this.listener);
            installation = installation.forEnvironment(env);
        }
        if (!env.containsKey((Object)"JAVA_HOME")) {
            this.muxlog.warn("{} is not configured; results may be unpredictable", (Object)"JAVA_HOME");
        }
        MavenInstallationValidator validator = new MavenInstallationValidator(installation, this.build, env, this.launcher, this.listener);
        validator.validate();
        FilePath tmpDir = this.build.getWorkspace().child(".maven/tmp");
        tmpDir.mkdirs();
        builder.withWindows(!this.launcher.isUnix()).withConfiguration(((MavenBuilder)this.owner).getConfig()).withMavenHome(validator.getHome()).withMavenExecutable(validator.getExecutable()).withExtClasspath(validator.getExtClasspath()).withBuildVariables(this.build.getBuildVariables()).withEnv(env).withWorkingDirectory(this.build.getWorkspace()).withRepository(this.build.getWorkspace().child(".maven/repo")).withTmpDir(tmpDir).withStandardOutput(this.listener.getLogger());
        OpenServerSocket.Acceptor acceptor = (OpenServerSocket.Acceptor)this.launcher.getChannel().call((Callable)new OpenServerSocket());
        int port = acceptor.getPort();
        builder.withPort(port);
        Launcher.ProcStarter starter = builder.build(this.launcher.launch());
        Proc process = starter.start();
        this.muxlog.debug("Waiting for connection on port: {}", (Object)port);
        try {
            connection = acceptor.accept(true);
        }
        catch (SocketTimeoutException e) {
            this.log.debug("Failed to accept connection", (Throwable)e);
            if (!process.isAlive()) {
                String message = "Process did not initiate connection and appears to have died; exit code: " + process.join();
                this.muxlog.error(message);
                throw new AbortException(message);
            }
            this.muxlog.error("Process did not initiate connection and is still alive; killing it");
            process.kill();
            throw new AbortException("Process failed to connect; exit code: " + process.join());
        }
        Channel channel = Channels.forProcess((String)("EventSpy:" + starter.cmds()), (ExecutorService)Computer.threadPoolForRemoting, (InputStream)new BufferedInputStream(connection.getInput()), (OutputStream)new BufferedOutputStream(connection.getOutput()), null, (Proc)process);
        this.muxlog.debug("Connected to remote");
        CallbackImpl callback = new CallbackImpl((MavenBuilder)this.owner, this.state, this.build);
        StartProcessing command = new StartProcessing(callback);
        PropertiesDTO props = ((MavenBuilder)this.owner).getConfig().getProperties();
        if (props != null && props.contains((Object)"hudson.eventspy.invoke.record.file")) {
            FilePath path = this.build.getWorkspace().child(props.get((Object)"hudson.eventspy.invoke.record.file"));
            this.muxlog.info("Recording invocations to: {}", (Object)path);
            command.recordInvocationsTo(path);
        }
        channel.call((Callable)command);
        this.muxlog.debug("Closing connection to remote");
        channel.close();
        connection.close();
        acceptor.close();
        this.muxlog.debug("Waiting for process to finish");
        int result = process.join();
        this.muxlog.debug("Result: {}", (Object)result);
        return result == 0;
    }

    protected void onFailure(Throwable cause) {
        super.onFailure(cause);
        this.state.getExecutionActivities().add(new ExecutionActivityDTO().withType(ExecutionActivityTypeDTO.ABORTED).withTimestamp(new Date()));
        for (MavenProjectDTO project : this.state.getParticipatingProjects()) {
            BuildSummaryDTO buildSummary = project.getBuildSummary();
            if (null == buildSummary) {
                project.setBuildSummary(new BuildSummaryDTO().withResult(BuildResultDTO.ABORTED));
                continue;
            }
            if (!INCOMPLETE_STATES.contains(buildSummary.getResult())) continue;
            buildSummary.withResult(BuildResultDTO.ABORTED);
        }
    }
}

