/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.dependencymonitor;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import org.hudsonci.maven.model.MavenCoordinatesDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactsPair {
    public final Collection<MavenCoordinatesDTO> produced;
    public final Collection<MavenCoordinatesDTO> consumed;

    public ArtifactsPair(Collection<MavenCoordinatesDTO> produced, Collection<MavenCoordinatesDTO> consumed) {
        this.produced = produced != null ? produced : Sets.newHashSet();
        this.consumed = consumed != null ? consumed : Sets.newHashSet();
    }

    public ArtifactsPair() {
        this(null, null);
    }

    public boolean isEmpty() {
        return this.produced.isEmpty() && this.consumed.isEmpty();
    }

    public ArtifactsPair withProduced(MavenCoordinatesDTO ... artifacts) {
        if (artifacts != null) {
            this.produced.addAll(Arrays.asList(artifacts));
        }
        return this;
    }

    public ArtifactsPair withConsumed(MavenCoordinatesDTO ... artifacts) {
        if (artifacts != null) {
            this.consumed.addAll(Arrays.asList(artifacts));
        }
        return this;
    }
}

