/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.dependencymonitor;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.maven.plugin.dependencymonitor.DependencyMonitor;
import org.hudsonci.service.DependencyGraphService;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="maven-dependency-notifier")
public class DependencyNotifier
extends Notifier
implements DependecyDeclarer,
MatrixAggregatable {
    private static final Logger log = LoggerFactory.getLogger(DependencyNotifier.class);
    private final boolean notifyIfUnstable;

    @DataBoundConstructor
    public DependencyNotifier(boolean notifyIfUnstable) {
        this.notifyIfUnstable = notifyIfUnstable;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @JellyAccessible
    public boolean isNotifyIfUnstable() {
        return this.notifyIfUnstable;
    }

    public Result getResultThreshold() {
        return this.notifyIfUnstable ? Result.UNSTABLE : Result.SUCCESS;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return true;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                log.debug("Forcing rebuild of graph for multi-config project: {}", (Object)this.build);
                DependencyNotifier.this.getDescriptor().dependencyGraphService.rebuild();
                DependencyNotifier.this.getDescriptor().dependencyGraphService.triggerDependents((AbstractBuild)this.build, (TaskListener)this.listener);
                return true;
            }
        };
    }

    public void buildDependencyGraph(AbstractProject project, DependencyGraph graph) {
        this.getDescriptor().dependencyMonitor.buildGraph(project, graph);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Named
    @Singleton
    @Typed(value={Descriptor.class})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private final DependencyMonitor dependencyMonitor;
        private final DependencyGraphService dependencyGraphService;

        @Inject
        public DescriptorImpl(DependencyMonitor dependencyMonitor, DependencyGraphService dependencyGraphService) {
            this.dependencyMonitor = (DependencyMonitor)Preconditions.checkNotNull((Object)dependencyMonitor);
            this.dependencyGraphService = (DependencyGraphService)Preconditions.checkNotNull((Object)dependencyGraphService);
        }

        public boolean isApplicable(Class<? extends AbstractProject> type) {
            return Project.class.isAssignableFrom(type) || MatrixProject.class.isAssignableFrom(type);
        }

        public String getDisplayName() {
            return "Notify that Maven dependencies have been updated by Maven 3 integration";
        }
    }
}

