/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.dependencymonitor.internal;

import com.google.common.base.Preconditions;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.DependencyGraph;
import hudson.model.TaskListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hudsonci.maven.model.MavenCoordinatesDTO;
import org.hudsonci.maven.plugin.dependencymonitor.DependencyMonitor;
import org.hudsonci.maven.plugin.dependencymonitor.DependencyNotifier;
import org.hudsonci.maven.plugin.dependencymonitor.ProjectArtifactCache;
import org.hudsonci.maven.plugin.dependencymonitor.internal.CollectionsHelper;
import org.hudsonci.service.DependencyGraphService;
import org.hudsonci.utils.tasks.MetaProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DependencyMonitorImpl
implements DependencyMonitor {
    private static final Logger log = LoggerFactory.getLogger(DependencyMonitorImpl.class);
    private final ProjectArtifactCache projectArtifactCache;
    private final DependencyGraphService dependencyGraphService;
    private final Set<AbstractProject> subscribedProjects = Collections.synchronizedSet(new HashSet());
    private volatile boolean primed;

    @Inject
    public DependencyMonitorImpl(ProjectArtifactCache projectArtifactCache, DependencyGraphService dependencyGraphService) {
        this.projectArtifactCache = (ProjectArtifactCache)Preconditions.checkNotNull((Object)projectArtifactCache);
        this.dependencyGraphService = (DependencyGraphService)Preconditions.checkNotNull((Object)dependencyGraphService);
    }

    public void subscribe(AbstractProject project) {
        Preconditions.checkNotNull((Object)project);
        log.debug("Subscribe: {}", (Object)project);
        this.subscribedProjects.add(project);
    }

    public void unsubscribe(AbstractProject project) {
        Preconditions.checkNotNull((Object)project);
        log.debug("Unsubscribe: {}", (Object)project);
        this.subscribedProjects.remove(project);
    }

    private boolean isSubscribedForArtifactNotifications(AbstractProject project) {
        return this.subscribedProjects.contains(project);
    }

    public void purge(AbstractProject project) {
        Preconditions.checkNotNull((Object)project);
        log.debug("Purge: {}", (Object)project);
        this.subscribedProjects.remove(project);
        this.projectArtifactCache.purgeArtifacts(project);
    }

    public void update(AbstractBuild build, TaskListener listener) {
        Preconditions.checkNotNull((Object)build);
        Preconditions.checkNotNull((Object)listener);
        log.debug("Update artifacts for build: {}", (Object)build);
        if (this.projectArtifactCache.updateArtifacts(build)) {
            this.dependencyGraphService.rebuild();
        }
    }

    private DependencyNotifier findDependencyNotifier(AbstractProject project) {
        return (DependencyNotifier)new MetaProject(project).getPublishersList().get(DependencyNotifier.class);
    }

    private void prime() {
        if (!this.primed) {
            this.projectArtifactCache.rebuild();
            this.primed = true;
            log.debug("Primed");
        }
    }

    public void buildGraph(AbstractProject project, DependencyGraph graph) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkNotNull((Object)graph);
        this.prime();
        log.debug("Build dependency graph for: {}", (Object)project);
        final DependencyNotifier notifier = this.findDependencyNotifier(project);
        if (notifier == null) {
            log.trace("Project is not producing artifacts; skipping");
            return;
        }
        AbstractProject producerProject = project;
        Collection<MavenCoordinatesDTO> producedArtifacts = this.projectArtifactCache.getProducedArtifacts(producerProject);
        for (AbstractProject consumerProject : this.projectArtifactCache.getArtifactConsumers()) {
            if (!this.isSubscribedForArtifactNotifications(consumerProject)) {
                log.trace("Consumer project is not subscribed for notifications; skipping: {}", (Object)consumerProject);
                continue;
            }
            Collection<MavenCoordinatesDTO> consumedArtifacts = this.projectArtifactCache.getConsumedArtifacts(consumerProject);
            if (!CollectionsHelper.containsAny(consumedArtifacts, producedArtifacts)) continue;
            log.debug("{} depends on {}", (Object)consumerProject, (Object)producerProject);
            DependencyGraph.Dependency dependency = new DependencyGraph.Dependency(producerProject, consumerProject){

                public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
                    if (log.isDebugEnabled()) {
                        log.debug("Checking if build should trigger: {}; w/threshold: {}", (Object)build, (Object)notifier.getResultThreshold());
                    }
                    return build.getResult().isBetterOrEqualTo(notifier.getResultThreshold());
                }
            };
            graph.addDependency(dependency);
        }
    }
}

