/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.dependencymonitor.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hudsonci.maven.model.MavenCoordinatesDTO;
import org.hudsonci.maven.plugin.dependencymonitor.ArtifactsExtractor;
import org.hudsonci.maven.plugin.dependencymonitor.ArtifactsPair;
import org.hudsonci.maven.plugin.dependencymonitor.ProjectArtifactCache;
import org.hudsonci.maven.plugin.dependencymonitor.internal.CollectionsHelper;
import org.hudsonci.service.ProjectService;
import org.hudsonci.utils.common.Varargs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ProjectArtifactCacheImpl
implements ProjectArtifactCache {
    private static final Logger log = LoggerFactory.getLogger(ProjectArtifactCacheImpl.class);
    private final ProjectService projectService;
    private final ArtifactsExtractor artifactsExtractor;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Multimap<AbstractProject, MavenCoordinatesDTO> projectProducedArtifacts = HashMultimap.create();
    private final Multimap<AbstractProject, MavenCoordinatesDTO> projectConsumedArtifacts = HashMultimap.create();

    @Inject
    public ProjectArtifactCacheImpl(ProjectService projectService, ArtifactsExtractor artifactsExtractor) {
        this.projectService = (ProjectService)Preconditions.checkNotNull((Object)projectService);
        this.artifactsExtractor = (ArtifactsExtractor)Preconditions.checkNotNull((Object)artifactsExtractor);
    }

    private Lock readLock() {
        Lock tmp = this.lock.readLock();
        tmp.lock();
        return tmp;
    }

    private Lock writeLock() {
        Lock tmp = this.lock.readLock();
        tmp.lock();
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArtifactsPair getArtifacts(AbstractProject project) {
        Preconditions.checkNotNull((Object)project);
        Lock lock = this.readLock();
        try {
            ArtifactsPair artifactsPair = new ArtifactsPair(this.getProducedArtifacts(project), this.getConsumedArtifacts(project));
            return artifactsPair;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<MavenCoordinatesDTO> getProducedArtifacts(AbstractProject project) {
        Preconditions.checkNotNull((Object)project);
        Lock lock = this.readLock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.projectProducedArtifacts.get((Object)project));
            return immutableSet;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<MavenCoordinatesDTO> getConsumedArtifacts(AbstractProject project) {
        Preconditions.checkNotNull((Object)project);
        Lock lock = this.readLock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.projectConsumedArtifacts.get((Object)project));
            return immutableSet;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AbstractProject> getArtifactProducers() {
        Lock lock = this.readLock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.projectProducedArtifacts.keySet());
            return immutableSet;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AbstractProject> getArtifactConsumers() {
        Lock lock = this.readLock();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.projectConsumedArtifacts.keySet());
            return immutableSet;
        }
        finally {
            lock.unlock();
        }
    }

    private Collection<AbstractProject> projectsContaining(Multimap<AbstractProject, MavenCoordinatesDTO> source, MavenCoordinatesDTO artifact) {
        assert (source != null);
        assert (artifact != null);
        HashSet projects = Sets.newHashSet();
        for (AbstractProject project : source.keySet()) {
            if (!source.containsEntry((Object)project, (Object)artifact)) continue;
            projects.add(project);
        }
        return projects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AbstractProject> getProducersOf(MavenCoordinatesDTO artifact) {
        Preconditions.checkNotNull((Object)artifact);
        Lock lock = this.readLock();
        try {
            Collection<AbstractProject> collection = this.projectsContaining(this.projectProducedArtifacts, artifact);
            return collection;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AbstractProject> getConsumersOf(MavenCoordinatesDTO artifact) {
        Preconditions.checkNotNull((Object)artifact);
        Lock lock = this.readLock();
        try {
            Collection<AbstractProject> collection = this.projectsContaining(this.projectConsumedArtifacts, artifact);
            return collection;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        log.debug("Clearing");
        Lock lock = this.writeLock();
        try {
            this.projectProducedArtifacts.clear();
            this.projectConsumedArtifacts.clear();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuild() {
        log.debug("Rebuilding");
        Lock lock = this.writeLock();
        try {
            this.clear();
            for (AbstractProject project : this.projectService.getAllProjects()) {
                ArtifactsPair artifacts = this.artifactsExtractor.extract(project);
                if (artifacts == null) continue;
                this.updateArtifacts(project, artifacts);
                if (!log.isDebugEnabled()) continue;
                log.debug("Cached artifacts for: {}, produced: {}, consumed: {}", Varargs.$((Object[])new Object[]{project, artifacts.produced.size(), artifacts.consumed.size()}));
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean updateArtifacts(AbstractBuild build) {
        Preconditions.checkNotNull((Object)build);
        log.debug("Updating artifacts for build: {}", (Object)build);
        ArtifactsPair artifacts = this.artifactsExtractor.extract(build);
        if (artifacts == null) {
            log.debug("Build produced and consumed no artifacts");
            return false;
        }
        AbstractProject project = build.getProject();
        return this.updateArtifacts(project, artifacts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateArtifacts(AbstractProject project, ArtifactsPair artifacts) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkNotNull((Object)artifacts);
        if (log.isDebugEnabled()) {
            log.debug("Updating produced and consumed artifacts for project: {}", (Object)project);
            if (log.isTraceEnabled()) {
                if (artifacts.produced != null) {
                    log.trace("  Produced:");
                    for (MavenCoordinatesDTO artifact : artifacts.produced) {
                        log.trace("    {}", (Object)artifact);
                    }
                }
                if (artifacts.produced != null) {
                    log.trace("  Consumed:");
                    for (MavenCoordinatesDTO artifact : artifacts.consumed) {
                        log.trace("    {}", (Object)artifact);
                    }
                }
            }
        }
        Lock lock = this.writeLock();
        try {
            boolean changed = false;
            if (this.updateArtifacts(this.projectProducedArtifacts, project, artifacts.produced)) {
                changed = true;
            }
            if (this.updateArtifacts(this.projectConsumedArtifacts, project, artifacts.consumed)) {
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean updateArtifacts(Multimap<AbstractProject, MavenCoordinatesDTO> collection, AbstractProject project, Collection<MavenCoordinatesDTO> artifacts) {
        assert (collection != null);
        Collection removed = collection.replaceValues((Object)project, artifacts);
        return CollectionsHelper.differs(artifacts, removed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeArtifacts(AbstractProject project) {
        Preconditions.checkNotNull((Object)project);
        log.debug("Puring artifacts for project: {}", (Object)project);
        Lock lock = this.writeLock();
        try {
            this.projectProducedArtifacts.removeAll((Object)project);
            this.projectConsumedArtifacts.removeAll((Object)project);
        }
        finally {
            lock.unlock();
        }
    }

    private boolean projectsContain(Multimap<AbstractProject, MavenCoordinatesDTO> source, MavenCoordinatesDTO artifact) {
        assert (source != null);
        assert (artifact != null);
        for (AbstractProject project : source.keySet()) {
            if (!source.containsEntry((Object)project, (Object)artifact)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProduced(MavenCoordinatesDTO artifact) {
        Preconditions.checkNotNull((Object)artifact);
        Lock lock = this.readLock();
        try {
            boolean bl = this.projectsContain(this.projectProducedArtifacts, artifact);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConsumed(MavenCoordinatesDTO artifact) {
        Preconditions.checkNotNull((Object)artifact);
        Lock lock = this.readLock();
        try {
            boolean bl = this.projectsContain(this.projectConsumedArtifacts, artifact);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }
}

