/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal;

import com.google.common.base.Preconditions;
import java.util.Date;
import javax.inject.Inject;
import org.hudsonci.maven.model.state.BuildStateDTO;
import org.hudsonci.maven.model.state.ExecutionActivityDTO;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.BuildSummaryPresenter;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.ModuleFormatter;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal.ModuleDataProvider;

public class BuildSummaryPresenterImpl
implements BuildSummaryPresenter {
    private final BuildSummaryPresenter.BuildSummaryView view;

    @Inject
    public BuildSummaryPresenterImpl(BuildSummaryPresenter.BuildSummaryView view, ModuleDataProvider mdp) {
        this.view = (BuildSummaryPresenter.BuildSummaryView)Preconditions.checkNotNull((Object)view);
        view.setModuleData(mdp);
    }

    public void setBuildState(BuildStateDTO buildState) {
        this.view.setBuildSummaryText(this.generateSummaryText(buildState));
    }

    private String generateSummaryText(BuildStateDTO buildState) {
        StringBuilder sb = new StringBuilder();
        sb.append("Execution of: ").append(buildState.getBuildConfiguration().getGoals());
        Date start = null;
        Date end = null;
        for (ExecutionActivityDTO activity : buildState.getExecutionActivities()) {
            switch (activity.getType()) {
                case STARTED: {
                    start = activity.getTimestamp();
                    break;
                }
                case FINISHED: {
                    end = activity.getTimestamp();
                }
            }
        }
        if (start != null && end != null) {
            sb.append(" completed in ");
            sb.append(ModuleFormatter.formatTime(end.getTime() - start.getTime()));
        }
        return sb.toString();
    }
}

