/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hudsonci.maven.model.PropertiesDTO;
import org.hudsonci.maven.model.state.BuildStateDTO;
import org.hudsonci.maven.model.state.RuntimeEnvironmentDTO;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.BuildInformationManager;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.MainPanelPresenter;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.event.BuildStateSelectedEvent;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.gin.FirstShownInfoDisplay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class MainPanelPresenterImpl
implements MainPanelPresenter {
    private final MainPanelPresenter.MainPanelView view;
    private final EventBus eventBus;
    private List<BuildStateDTO> buildStates;
    private int currentBuildState = 0;
    private final BuildInformationManager dataManager;

    @Inject
    public MainPanelPresenterImpl(MainPanelPresenter.MainPanelView view, @FirstShownInfoDisplay IsWidget firstDisplay, EventBus eventBus, BuildInformationManager dataManager) {
        this.view = view;
        this.view.setFirstShownWidget(firstDisplay);
        this.view.setPresenter(this);
        this.eventBus = eventBus;
        this.dataManager = dataManager;
    }

    @Override
    public void bind(HasWidgets container) {
        container.add(this.view.asWidget());
    }

    @Override
    public void setBuildStates(List<BuildStateDTO> buildStates) {
        this.buildStates = buildStates;
        this.buildStateSelected(this.currentBuildState);
        if (buildStates.size() > 1) {
            ArrayList<String> stateNames = new ArrayList<String>();
            int i = 1;
            for (BuildStateDTO state : buildStates) {
                stateNames.add(i + " : " + state.getBuildConfiguration().getGoals());
                ++i;
            }
            this.view.setStateSelectionNames(stateNames);
            this.view.showStatePicker(this.currentBuildState);
        }
    }

    @Override
    public void buildStateSelected(int selectedIndex) {
        this.currentBuildState = selectedIndex;
        BuildStateDTO selectedState = this.buildStates.get(selectedIndex);
        this.eventBus.fireEvent((GwtEvent)new BuildStateSelectedEvent(selectedState));
        this.updateViewData(selectedState);
    }

    @Override
    public void selectModuleInfo() {
        this.view.selectModuleInfo();
    }

    @Override
    public void refresh() {
        this.dataManager.refresh();
    }

    private void updateViewData(BuildStateDTO selectedState) {
        RuntimeEnvironmentDTO runtime = selectedState.getRuntimeEnvironment();
        if (runtime != null) {
            Log.debug((String)"Runtime data available, updating view.");
            this.view.setVersionData(this.maybeNullAsEmptyCollection(runtime.getVersionProperties()));
            this.view.setUserData(this.maybeNullAsEmptyCollection(runtime.getUserProperties()));
            this.view.setSystemData(this.maybeNullAsEmptyCollection(runtime.getSystemProperties()));
            this.view.setEnvironmentData(this.maybeNullAsEmptyCollection(runtime.getSystemEnvironment()));
        } else {
            Log.debug((String)"Runtime data NOT available, updating view with empty collections.");
            this.view.setVersionData(Collections.<PropertiesDTO.Entry>emptyList());
            this.view.setUserData(Collections.<PropertiesDTO.Entry>emptyList());
            this.view.setSystemData(Collections.<PropertiesDTO.Entry>emptyList());
            this.view.setEnvironmentData(Collections.<PropertiesDTO.Entry>emptyList());
        }
    }

    private List<PropertiesDTO.Entry> maybeNullAsEmptyCollection(PropertiesDTO propertiesDto) {
        return propertiesDto == null ? Collections.emptyList() : propertiesDto.getEntries();
    }
}

