/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.configure.documents.internal;

import com.google.common.base.Preconditions;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hudsonci.gwt.common.confirmdialog.ConfirmDialogPresenter;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.Document;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.DocumentDetailPresenter;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.DocumentManagerLiaison;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.DocumentMasterPresenter;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.DocumentMasterView;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.event.DocumentAddedEvent;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.event.DocumentSelectedEvent;
import org.hudsonci.maven.plugin.ui.gwt.configure.documents.event.DocumentUpdatedEvent;

@Singleton
public class DocumentMasterPresenterImpl
implements DocumentMasterPresenter {
    private final DocumentMasterView view;
    private final EventBus eventBus;
    private final DocumentManagerLiaison documentManagerLiaison;
    private final DocumentDetailPresenter documentDetailPresenter;
    private final ConfirmDialogPresenter confirmDialogPresenter;
    private final DocumentMasterPresenter.MessagesResource messages;
    private final SingleSelectionModel<Document> selectionModel;

    @Inject
    public DocumentMasterPresenterImpl(final DocumentMasterView view, EventBus eventBus, Scheduler scheduler, final DocumentManagerLiaison documentManagerLiaison, DocumentDetailPresenter documentDetailPresenter, ConfirmDialogPresenter confirmDialogPresenter, DocumentMasterPresenter.MessagesResource messages) {
        this.view = (DocumentMasterView)Preconditions.checkNotNull((Object)view);
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.documentManagerLiaison = (DocumentManagerLiaison)Preconditions.checkNotNull((Object)documentManagerLiaison);
        this.documentDetailPresenter = (DocumentDetailPresenter)Preconditions.checkNotNull((Object)documentDetailPresenter);
        this.confirmDialogPresenter = (ConfirmDialogPresenter)Preconditions.checkNotNull((Object)confirmDialogPresenter);
        this.messages = (DocumentMasterPresenter.MessagesResource)Preconditions.checkNotNull((Object)messages);
        view.setPresenter(this);
        HasData<Document> documentDataContainer = view.getDocumentDataContainer();
        this.selectionModel = new SingleSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                Document document = (Document)DocumentMasterPresenterImpl.this.selectionModel.getSelectedObject();
                DocumentMasterPresenterImpl.this.fireDocumentSelected(document);
                view.setDocumentSelected(true);
            }
        });
        documentDataContainer.setSelectionModel(this.selectionModel);
        documentManagerLiaison.getDataProvider().addDataDisplay(documentDataContainer);
        view.setDocumentDetailView(documentDetailPresenter.getView());
        eventBus.addHandler(DocumentSelectedEvent.TYPE, (EventHandler)documentDetailPresenter);
        eventBus.addHandler(DocumentAddedEvent.TYPE, (EventHandler)documentDetailPresenter);
        eventBus.addHandler(DocumentUpdatedEvent.TYPE, (EventHandler)documentDetailPresenter);
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                documentManagerLiaison.fetchAll();
            }
        });
    }

    public DocumentMasterView getView() {
        return this.view;
    }

    private void fireDocumentSelected(Document document) {
        this.eventBus.fireEvent((GwtEvent)new DocumentSelectedEvent(document));
    }

    public void doRefresh() {
        this.documentDetailPresenter.doCancel();
        this.documentManagerLiaison.fetchAll();
    }

    public void doAdd() {
        Document document = this.documentManagerLiaison.create();
        this.selectionModel.setSelected((Object)document, true);
        this.view.scrollToNewDocument();
    }

    public void doRemove() {
        final Document document = (Document)this.selectionModel.getSelectedObject();
        assert (document != null);
        this.confirmDialogPresenter.confirm(this.messages.removeTitle(), this.messages.removeMessage(document.getDisplayName()), new ConfirmDialogPresenter.OkCancelCallback(){

            public void onOk() {
                DocumentMasterPresenterImpl.this.documentDetailPresenter.setDocument(null);
                DocumentMasterPresenterImpl.this.documentManagerLiaison.remove(document);
                DocumentMasterPresenterImpl.this.view.setDocumentSelected(false);
            }

            public void onCancel() {
            }
        });
    }
}

