/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.artifactrecorder;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.FingerprintMap;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.hudsonci.maven.plugin.artifactrecorder.ArtifactFingerprinter;
import org.hudsonci.maven.plugin.artifactrecorder.internal.PerformFingerprinting;
import org.hudsonci.maven.plugin.builder.BuildStateRecord;
import org.kohsuke.stapler.DataBoundConstructor;

@XStreamAlias(value="maven-artifact-fingerprinter")
public class ArtifactFingerprinter
extends Recorder {
    @XStreamOmitField
    private FingerprintMap registry;

    @DataBoundConstructor
    public ArtifactFingerprinter() {
    }

    @Inject
    public void setFingerprintRegistry(FingerprintMap fingerprintRegistry) {
        this.registry = fingerprintRegistry;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().isWorseThan(Result.UNSTABLE)) {
            return true;
        }
        List records = build.getActions(BuildStateRecord.class);
        HashSet artifacts = new HashSet();
        for (BuildStateRecord record : records) {
            artifacts.addAll(record.getState().getArtifacts());
        }
        return new PerformFingerprinting(this, build, launcher, listener, records.size(), artifacts, this.registry).execute();
    }
}

