/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder.internal;

import com.google.common.base.Preconditions;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Launcher;
import hudson.util.ArgumentListBuilder;
import hudson.util.ClasspathBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.hudsonci.maven.plugin.builder.internal.MavenConstants;
import org.hudsonci.maven.plugin.builder.internal.MavenVersionParser;
import org.hudsonci.maven.plugin.install.MavenInstallation;
import org.hudsonci.maven.plugin.install.SlaveBundleInstaller;
import org.hudsonci.utils.tasks.Chmod;
import org.hudsonci.utils.tasks.FetchClassLocation;
import org.hudsonci.utils.tasks.TaskListenerLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.util.version.GenericVersionScheme;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionConstraint;
import org.sonatype.gossip.support.MuxLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenInstallationValidator {
    private static final Logger log = LoggerFactory.getLogger(MavenInstallationValidator.class);
    private final MavenInstallation installation;
    private final AbstractBuild<?, ?> build;
    private final EnvVars buildEnv;
    private final hudson.Launcher launcher;
    private final BuildListener listener;
    private final TaskListenerLogger logger;
    private final Logger muxlog;
    private FilePath home;
    private FilePath executable;
    private String mavenVersion;
    private static final long timeout = 60L;
    private static final TimeUnit timeoutUnit = TimeUnit.SECONDS;
    private ClasspathBuilder extClasspath;

    public MavenInstallationValidator(MavenInstallation installation, AbstractBuild<?, ?> build, EnvVars buildEnv, hudson.Launcher launcher, BuildListener listener) {
        this.installation = (MavenInstallation)Preconditions.checkNotNull((Object)installation);
        this.build = (AbstractBuild)Preconditions.checkNotNull(build);
        this.buildEnv = (EnvVars)Preconditions.checkNotNull((Object)buildEnv);
        this.launcher = (hudson.Launcher)Preconditions.checkNotNull((Object)launcher);
        this.listener = (BuildListener)Preconditions.checkNotNull((Object)listener);
        this.logger = new TaskListenerLogger((TaskListener)listener);
        this.muxlog = MuxLoggerFactory.create((Logger[])new Logger[]{log, this.logger});
    }

    public FilePath getHome() {
        if (this.home == null) {
            this.home = new FilePath(this.launcher.getChannel(), this.installation.getHome());
        }
        return this.home;
    }

    private void ensureFileExists(FilePath file) throws Exception {
        if (!file.exists()) {
            throw new AbortException(String.format("Missing required file: %s", file));
        }
    }

    public FilePath getExecutable() throws Exception {
        if (this.executable == null) {
            String file = "mvn";
            if (!this.launcher.isUnix()) {
                file = file + ".bat";
            }
            FilePath dir = this.getHome();
            FilePath mvn = dir.child("bin").child(file);
            this.ensureFileExists(mvn);
            if (this.launcher.isUnix()) {
                mvn.act((FilePath.FileCallable)new Chmod(493));
            }
            this.executable = mvn;
        }
        return this.executable;
    }

    private String getMavenVersion() throws Exception {
        if (this.mavenVersion == null) {
            this.muxlog.info("Checking Maven 3 installation version");
            this.mavenVersion = this.getMavenVersionFromProperties();
            if (this.mavenVersion == null) {
                this.mavenVersion = this.getMavenVersionFromConsole();
            }
            this.muxlog.info("Detected Maven 3 installation version: {}", (Object)this.mavenVersion);
        }
        return this.mavenVersion;
    }

    private String getMavenVersionFromProperties() {
        try {
            FilePath[] jars = this.getHome().child("lib").list("maven-core-*.jar, maven-*-uber.jar");
            if (jars != null && jars.length > 0) {
                FilePath jar = jars[0];
                Properties mavenProperties = (Properties)jar.act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
                if (this.muxlog.isTraceEnabled()) {
                    this.muxlog.trace("Maven installation properties: {}", (Object)mavenProperties);
                }
                if (mavenProperties != null) {
                    return mavenProperties.getProperty("version");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String getMavenVersionFromConsole() throws Exception {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add((Object)this.getExecutable());
        args.add("--version");
        EnvVars env = new EnvVars();
        this.maybyPut("JAVA_HOME", this.buildEnv, env);
        env.put("M2_HOME", this.getHome().getRemote());
        env.put("MAVEN_SKIP_RC", MavenConstants.TRUE);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Proc process = this.launcher.launch().cmds(args).envs((Map)env).pwd(this.build.getWorkspace()).stdout((OutputStream)buffer).start();
        int result = process.joinWithTimeout(60L, timeoutUnit, (TaskListener)this.listener);
        String output = new String(buffer.toByteArray());
        if (this.muxlog.isTraceEnabled()) {
            this.muxlog.trace("Process output:\n{}", (Object)output);
        }
        if (result != 0) {
            throw new AbortException(String.format("Failed to determine Maven 3 installation version; unexpected exit code: %d, command output: %s", process.join(), output));
        }
        BufferedReader reader = new BufferedReader(new StringReader(output));
        String version = new MavenVersionParser().parse(reader);
        if (version == null) {
            throw new AbortException(String.format("Failed to determine Maven 3 installation version; unable to parse version from: %s", output));
        }
        return version;
    }

    private void maybyPut(String key, EnvVars source, EnvVars target) {
        String value = (String)source.get((Object)key);
        if (value != null) {
            target.put(key, value);
        }
    }

    public String getEventSpyVersion() throws Exception {
        Version version;
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        VersionConstraint versionConstraint = new GenericVersionScheme().parseVersionConstraint("[3.0.3,)");
        String tmp = this.getMavenVersion();
        try {
            version = versionScheme.parseVersion(tmp);
        }
        catch (Exception e) {
            throw new AbortException("Unable to parse Maven version: " + tmp);
        }
        if (versionConstraint.containsVersion(version)) {
            return "3.0";
        }
        throw new AbortException("Unsupported Maven version: " + version);
    }

    public void validate() throws Exception {
        this.muxlog.info("Checking Maven 3 installation environment");
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add((Object)this.getExecutable());
        args.add("--help");
        EnvVars env = new EnvVars();
        this.maybyPut("JAVA_HOME", this.buildEnv, env);
        env.put("M2_HOME", this.getHome().getRemote());
        env.put("MAVEN_SKIP_RC", MavenConstants.TRUE);
        env.put("MAVEN_OPTS", "--no-such-option");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Proc process = this.launcher.launch().cmds(args).envs((Map)env).pwd(this.build.getWorkspace()).stdout((OutputStream)buffer).start();
        int result = process.joinWithTimeout(60L, timeoutUnit, (TaskListener)this.listener);
        String output = new String(buffer.toByteArray());
        if (this.muxlog.isTraceEnabled()) {
            this.muxlog.trace("Process output:\n{}", (Object)output);
        }
        if (result == 0) {
            throw new AbortException("Invalid Maven 3 installation environment; unable to configure MAVEN_OPTS");
        }
    }

    public ClasspathBuilder getExtClasspath() throws Exception {
        if (this.extClasspath == null) {
            ClasspathBuilder cp = new ClasspathBuilder();
            FilePath root = SlaveBundleInstaller.getInstallRoot();
            FilePath file = root.child("resources");
            this.ensureFileExists(file);
            cp.add(file);
            file = root.child("lib").child(String.format("maven3-eventspy-%s.jar", this.getEventSpyVersion()));
            this.ensureFileExists(file);
            cp.add(file);
            file = (FilePath)this.launcher.getChannel().call((Callable)new FetchClassLocation(Launcher.class));
            this.ensureFileExists(file);
            cp.add(file);
            this.extClasspath = cp;
        }
        return this.extClasspath;
    }
}

